/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.delegate;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class BpmnError
extends ProcessEngineException {
    private static final long serialVersionUID = 1L;
    private String errorCode;
    private String errorMessage;

    public BpmnError(String errorCode) {
        super("");
        this.setErrorCode(errorCode);
    }

    public BpmnError(String errorCode, String message) {
        super(message + " (errorCode='" + errorCode + "')");
        this.setErrorCode(errorCode);
        this.setMessage(message);
    }

    protected void setErrorCode(String errorCode) {
        EnsureUtil.ensureNotEmpty("Error Code", errorCode);
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String toString() {
        return super.toString() + " (errorCode='" + this.errorCode + "')";
    }

    protected void setMessage(String errorMessage) {
        EnsureUtil.ensureNotEmpty("Error Message", errorMessage);
        this.errorMessage = errorMessage;
    }

    @Override
    public String getMessage() {
        return this.errorMessage;
    }
}

