/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.task;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.form.handler.TaskFormHandler;
import org.camunda.bpm.engine.impl.util.CollectionUtil;

public class TaskDefinition {
    protected String key;
    protected Expression nameExpression;
    protected Expression descriptionExpression;
    protected Expression assigneeExpression;
    protected Set<Expression> candidateUserIdExpressions = new HashSet<Expression>();
    protected Set<Expression> candidateGroupIdExpressions = new HashSet<Expression>();
    protected Expression dueDateExpression;
    protected Expression followUpDateExpression;
    protected Expression priorityExpression;
    protected TaskFormHandler taskFormHandler;
    protected Expression formKey;
    protected Map<String, List<TaskListener>> taskListeners = new HashMap<String, List<TaskListener>>();
    protected Map<String, List<TaskListener>> builtinTaskListeners = new HashMap<String, List<TaskListener>>();

    public TaskDefinition(TaskFormHandler taskFormHandler) {
        this.taskFormHandler = taskFormHandler;
    }

    public Expression getNameExpression() {
        return this.nameExpression;
    }

    public void setNameExpression(Expression nameExpression) {
        this.nameExpression = nameExpression;
    }

    public Expression getDescriptionExpression() {
        return this.descriptionExpression;
    }

    public void setDescriptionExpression(Expression descriptionExpression) {
        this.descriptionExpression = descriptionExpression;
    }

    public Expression getAssigneeExpression() {
        return this.assigneeExpression;
    }

    public void setAssigneeExpression(Expression assigneeExpression) {
        this.assigneeExpression = assigneeExpression;
    }

    public Set<Expression> getCandidateUserIdExpressions() {
        return this.candidateUserIdExpressions;
    }

    public void addCandidateUserIdExpression(Expression userId) {
        this.candidateUserIdExpressions.add(userId);
    }

    public Set<Expression> getCandidateGroupIdExpressions() {
        return this.candidateGroupIdExpressions;
    }

    public void addCandidateGroupIdExpression(Expression groupId) {
        this.candidateGroupIdExpressions.add(groupId);
    }

    public Expression getPriorityExpression() {
        return this.priorityExpression;
    }

    public void setPriorityExpression(Expression priorityExpression) {
        this.priorityExpression = priorityExpression;
    }

    public TaskFormHandler getTaskFormHandler() {
        return this.taskFormHandler;
    }

    public void setTaskFormHandler(TaskFormHandler taskFormHandler) {
        this.taskFormHandler = taskFormHandler;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Expression getDueDateExpression() {
        return this.dueDateExpression;
    }

    public void setDueDateExpression(Expression dueDateExpression) {
        this.dueDateExpression = dueDateExpression;
    }

    public Expression getFollowUpDateExpression() {
        return this.followUpDateExpression;
    }

    public void setFollowUpDateExpression(Expression followUpDateExpression) {
        this.followUpDateExpression = followUpDateExpression;
    }

    public Map<String, List<TaskListener>> getTaskListeners() {
        return this.taskListeners;
    }

    public Map<String, List<TaskListener>> getBuiltinTaskListeners() {
        return this.builtinTaskListeners;
    }

    public void setTaskListeners(Map<String, List<TaskListener>> taskListeners) {
        this.taskListeners = taskListeners;
    }

    public List<TaskListener> getTaskListeners(String eventName) {
        return this.taskListeners.get(eventName);
    }

    public List<TaskListener> getBuiltinTaskListeners(String eventName) {
        return this.builtinTaskListeners.get(eventName);
    }

    public void addTaskListener(String eventName, TaskListener taskListener) {
        CollectionUtil.addToMapOfLists(this.taskListeners, eventName, taskListener);
    }

    public void addBuiltInTaskListener(String eventName, TaskListener taskListener) {
        CollectionUtil.addToMapOfLists(this.taskListeners, eventName, taskListener);
        CollectionUtil.addToMapOfLists(this.builtinTaskListeners, eventName, taskListener);
    }

    public Expression getFormKey() {
        return this.formKey;
    }

    public void setFormKey(Expression formKey) {
        this.formKey = formKey;
    }
}

