/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.el;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.javax.el.FunctionMapper;
import org.camunda.bpm.engine.impl.util.ReflectUtil;

public class CommandContextFunctionMapper
extends FunctionMapper {
    public static Map<String, Method> COMMAND_CONTEXT_FUNCTION_MAP = null;

    @Override
    public Method resolveFunction(String prefix, String localName) {
        this.ensureContextFunctionMapInitialized();
        return COMMAND_CONTEXT_FUNCTION_MAP.get(localName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void ensureContextFunctionMapInitialized() {
        if (COMMAND_CONTEXT_FUNCTION_MAP != null) return;
        Class<CommandContextFunctionMapper> clazz = CommandContextFunctionMapper.class;
        synchronized (CommandContextFunctionMapper.class) {
            if (COMMAND_CONTEXT_FUNCTION_MAP != null) return;
            COMMAND_CONTEXT_FUNCTION_MAP = new HashMap<String, Method>();
            this.createMethodBindings();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void createMethodBindings() {
        Class<?> mapperClass = this.getClass();
        COMMAND_CONTEXT_FUNCTION_MAP.put("currentUser", ReflectUtil.getMethod(mapperClass, "currentUser", new Class[0]));
        COMMAND_CONTEXT_FUNCTION_MAP.put("currentUserGroups", ReflectUtil.getMethod(mapperClass, "currentUserGroups", new Class[0]));
    }

    public static String currentUser() {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            return commandContext.getAuthenticatedUserId();
        }
        return null;
    }

    public static List<String> currentUserGroups() {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            return commandContext.getAuthenticatedGroupIds();
        }
        return null;
    }
}

