/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.entity.repository;

import java.io.Serializable;
import org.camunda.bpm.dmn.engine.impl.DmnDecisionTableImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionManager;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.repository.ResourceDefinitionEntity;
import org.camunda.bpm.engine.repository.DecisionDefinition;

public class DecisionDefinitionEntity
extends DmnDecisionTableImpl
implements DecisionDefinition,
ResourceDefinitionEntity,
DbEntity,
HasDbRevision,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision = 1;
    protected String name;
    protected String category;
    protected String key;
    protected int version;
    protected String deploymentId;
    protected String resourceName;
    protected String diagramResourceName;
    protected String tenantId;
    protected boolean firstVersion = false;
    protected String previousDecisionDefinitionId;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
        this.firstVersion = this.version == 1;
    }

    @Override
    public String getDeploymentId() {
        return this.deploymentId;
    }

    @Override
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @Override
    public String getDiagramResourceName() {
        return this.diagramResourceName;
    }

    @Override
    public void setDiagramResourceName(String diagramResourceName) {
        this.diagramResourceName = diagramResourceName;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Object getPersistentState() {
        return DecisionDefinitionEntity.class;
    }

    @Override
    public DecisionDefinitionEntity getPreviousDefinition() {
        DecisionDefinitionEntity previousDecisionDefinition = null;
        String previousDecisionDefinitionId = this.getPreviousDecisionDefinitionId();
        if (previousDecisionDefinitionId != null && (previousDecisionDefinition = this.loadDecisionDefinition(previousDecisionDefinitionId)) == null) {
            this.resetPreviousDecisionDefinitionId();
            previousDecisionDefinitionId = this.getPreviousDecisionDefinitionId();
            if (previousDecisionDefinitionId != null) {
                previousDecisionDefinition = this.loadDecisionDefinition(previousDecisionDefinitionId);
            }
        }
        return previousDecisionDefinition;
    }

    protected DecisionDefinitionEntity loadDecisionDefinition(String decisionDefinitionId) {
        CommandContext commandContext;
        DecisionDefinitionManager decisionDefinitionManager;
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        DeploymentCache deploymentCache = configuration.getDeploymentCache();
        DecisionDefinitionEntity decisionDefinition = deploymentCache.findDecisionDefinitionFromCache(decisionDefinitionId);
        if (decisionDefinition == null && (decisionDefinition = (decisionDefinitionManager = (commandContext = Context.getCommandContext()).getDecisionDefinitionManager()).findDecisionDefinitionById(decisionDefinitionId)) != null) {
            decisionDefinition = deploymentCache.resolveDecisionDefinition(decisionDefinition);
        }
        return decisionDefinition;
    }

    public String getPreviousDecisionDefinitionId() {
        this.ensurePreviousDecisionDefinitionIdInitialized();
        return this.previousDecisionDefinitionId;
    }

    public void setPreviousDecisionDefinitionId(String previousDecisionDefinitionId) {
        this.previousDecisionDefinitionId = previousDecisionDefinitionId;
    }

    protected void resetPreviousDecisionDefinitionId() {
        this.previousDecisionDefinitionId = null;
        this.ensurePreviousDecisionDefinitionIdInitialized();
    }

    protected void ensurePreviousDecisionDefinitionIdInitialized() {
        if (this.previousDecisionDefinitionId == null && !this.firstVersion) {
            this.previousDecisionDefinitionId = Context.getCommandContext().getDecisionDefinitionManager().findPreviousDecisionDefinitionId(this.key, this.version, this.tenantId);
            if (this.previousDecisionDefinitionId == null) {
                this.firstVersion = true;
            }
        }
    }

    public String toString() {
        return "DecisionDefinitionEntity{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", category='" + this.category + '\'' + ", key='" + this.key + '\'' + ", version=" + this.version + ", deploymentId='" + this.deploymentId + '\'' + ", tenantId='" + this.tenantId + '\'' + '}';
    }
}

