/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.deployer;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.impl.AbstractDefinitionDeployer;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.diagram.ProcessDiagramGenerator;
import org.camunda.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParse;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParseLogger;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParser;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.cmd.DeleteJobsCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.model.Properties;
import org.camunda.bpm.engine.impl.core.model.PropertyMapKey;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionManager;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityLinkEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.pvm.runtime.LegacyBehavior;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class BpmnDeployer
extends AbstractDefinitionDeployer<ProcessDefinitionEntity> {
    public static BpmnParseLogger LOG = ProcessEngineLogger.BPMN_PARSE_LOGGER;
    public static final String[] BPMN_RESOURCE_SUFFIXES = new String[]{"bpmn20.xml", "bpmn"};
    protected static final PropertyMapKey<String, List<JobDeclaration<?, ?>>> JOB_DECLARATIONS_PROPERTY = new PropertyMapKey("JOB_DECLARATIONS_PROPERTY");
    protected ExpressionManager expressionManager;
    protected BpmnParser bpmnParser;

    @Override
    protected String[] getResourcesSuffixes() {
        return BPMN_RESOURCE_SUFFIXES;
    }

    @Override
    protected List<ProcessDefinitionEntity> transformDefinitions(DeploymentEntity deployment, ResourceEntity resource, Properties properties) {
        byte[] bytes = resource.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        BpmnParse bpmnParse = this.bpmnParser.createParse().sourceInputStream(inputStream).deployment(deployment).name(resource.getName());
        if (!deployment.isValidatingSchema()) {
            bpmnParse.setSchemaResource(null);
        }
        bpmnParse.execute();
        if (!properties.contains(JOB_DECLARATIONS_PROPERTY)) {
            properties.set(JOB_DECLARATIONS_PROPERTY, new HashMap());
        }
        properties.get(JOB_DECLARATIONS_PROPERTY).putAll(bpmnParse.getJobDeclarations());
        return bpmnParse.getProcessDefinitions();
    }

    @Override
    protected ProcessDefinitionEntity findDefinitionByDeploymentAndKey(String deploymentId, String definitionKey) {
        return this.getProcessDefinitionManager().findProcessDefinitionByDeploymentAndKey(deploymentId, definitionKey);
    }

    @Override
    protected ProcessDefinitionEntity findLatestDefinitionByKeyAndTenantId(String definitionKey, String tenantId) {
        return this.getProcessDefinitionManager().findLatestProcessDefinitionByKeyAndTenantId(definitionKey, tenantId);
    }

    @Override
    protected void persistDefinition(ProcessDefinitionEntity definition) {
        this.getProcessDefinitionManager().insertProcessDefinition(definition);
    }

    @Override
    protected void addDefinitionToDeploymentCache(DeploymentCache deploymentCache, ProcessDefinitionEntity definition) {
        deploymentCache.addProcessDefinition(definition);
    }

    @Override
    protected String generateDiagramResourceForDefinition(DeploymentEntity deployment, String resourceName, ProcessDefinitionEntity definition, Map<String, ResourceEntity> resources) {
        String diagramResourceName = null;
        if (deployment.isNew() && this.getProcessEngineConfiguration().isCreateDiagramOnDeploy() && definition.isGraphicalNotationDefined()) {
            try {
                byte[] diagramBytes = IoUtil.readInputStream(ProcessDiagramGenerator.generatePngDiagram(definition), null);
                diagramResourceName = this.getDefinitionDiagramResourceName(resourceName, definition, "png");
                this.createResource(diagramResourceName, diagramBytes, deployment);
            }
            catch (Throwable t) {
                LOG.exceptionWhileGeneratingProcessDiagram(t);
            }
        }
        return diagramResourceName;
    }

    @Override
    protected void definitionAddedToDeploymentCache(DeploymentEntity deployment, ProcessDefinitionEntity definition, Properties properties) {
        List<JobDeclaration<?, ?>> declarations = properties.get(JOB_DECLARATIONS_PROPERTY).get(definition.getKey());
        this.updateJobDeclarations(declarations, definition, deployment.isNew());
        ProcessDefinitionEntity latestDefinition = this.findLatestDefinitionByKeyAndTenantId(definition.getKey(), definition.getTenantId());
        if (deployment.isNew()) {
            this.adjustStartEventSubscriptions(definition, latestDefinition);
        }
        this.addAuthorizations(definition);
    }

    @Override
    protected void persistedDefinitionLoaded(DeploymentEntity deployment, ProcessDefinitionEntity definition, ProcessDefinitionEntity persistedDefinition) {
        definition.setSuspensionState(persistedDefinition.getSuspensionState());
    }

    protected void updateJobDeclarations(List<JobDeclaration<?, ?>> jobDeclarations, ProcessDefinitionEntity processDefinition, boolean isNewDeployment) {
        if (jobDeclarations == null || jobDeclarations.isEmpty()) {
            return;
        }
        JobDefinitionManager jobDefinitionManager = this.getJobDefinitionManager();
        if (isNewDeployment) {
            for (JobDeclaration<?, ?> jobDeclaration : jobDeclarations) {
                this.createJobDefinition(processDefinition, jobDeclaration);
            }
        } else {
            List<JobDefinitionEntity> existingDefinitions = jobDefinitionManager.findByProcessDefinitionId(processDefinition.getId());
            LegacyBehavior.migrateMultiInstanceJobDefinitions(processDefinition, existingDefinitions);
            for (JobDeclaration<?, ?> jobDeclaration : jobDeclarations) {
                boolean jobDefinitionExists = false;
                for (JobDefinitionEntity jobDefinitionEntity : existingDefinitions) {
                    if (!jobDeclaration.getActivityId().equals(jobDefinitionEntity.getActivityId()) || !jobDeclaration.getJobHandlerType().equals(jobDefinitionEntity.getJobType())) continue;
                    jobDeclaration.setJobDefinitionId(jobDefinitionEntity.getId());
                    jobDefinitionExists = true;
                    break;
                }
                if (jobDefinitionExists) continue;
                this.createJobDefinition(processDefinition, jobDeclaration);
            }
        }
    }

    protected void createJobDefinition(ProcessDefinition processDefinition, JobDeclaration<?, ?> jobDeclaration) {
        JobDefinitionManager jobDefinitionManager = this.getJobDefinitionManager();
        JobDefinitionEntity jobDefinitionEntity = new JobDefinitionEntity(jobDeclaration);
        jobDefinitionEntity.setProcessDefinitionId(processDefinition.getId());
        jobDefinitionEntity.setProcessDefinitionKey(processDefinition.getKey());
        jobDefinitionEntity.setTenantId(processDefinition.getTenantId());
        jobDefinitionManager.insert(jobDefinitionEntity);
        jobDeclaration.setJobDefinitionId(jobDefinitionEntity.getId());
    }

    protected void adjustStartEventSubscriptions(ProcessDefinitionEntity newLatestProcessDefinition, ProcessDefinitionEntity oldLatestProcessDefinition) {
        this.removeObsoleteTimers(newLatestProcessDefinition);
        this.addTimerDeclarations(newLatestProcessDefinition);
        this.removeObsoleteEventSubscriptions(newLatestProcessDefinition, oldLatestProcessDefinition);
        this.addEventSubscriptions(newLatestProcessDefinition);
    }

    protected void addTimerDeclarations(ProcessDefinitionEntity processDefinition) {
        List timerDeclarations = (List)processDefinition.getProperty("timerStart");
        if (timerDeclarations != null) {
            for (TimerDeclarationImpl timerDeclaration : timerDeclarations) {
                String deploymentId = processDefinition.getDeploymentId();
                timerDeclaration.createStartTimerInstance(deploymentId);
            }
        }
    }

    protected void removeObsoleteTimers(ProcessDefinitionEntity processDefinition) {
        List<JobEntity> jobsToDelete = this.getJobManager().findJobsByConfiguration("timer-start-event", processDefinition.getKey(), processDefinition.getTenantId());
        for (JobEntity job : jobsToDelete) {
            new DeleteJobsCmd(job.getId()).execute(Context.getCommandContext());
        }
    }

    protected void removeObsoleteEventSubscriptions(ProcessDefinitionEntity processDefinition, ProcessDefinitionEntity latestProcessDefinition) {
        if (latestProcessDefinition != null) {
            EventSubscriptionManager eventSubscriptionManager = this.getEventSubscriptionManager();
            ArrayList<EventSubscriptionEntity> subscriptionsToDelete = new ArrayList<EventSubscriptionEntity>();
            List<EventSubscriptionEntity> messageEventSubscriptions = eventSubscriptionManager.findEventSubscriptionsByConfiguration("message", latestProcessDefinition.getId());
            subscriptionsToDelete.addAll(messageEventSubscriptions);
            List<EventSubscriptionEntity> signalEventSubscriptions = eventSubscriptionManager.findEventSubscriptionsByConfiguration("signal", latestProcessDefinition.getId());
            subscriptionsToDelete.addAll(signalEventSubscriptions);
            for (EventSubscriptionEntity eventSubscriptionEntity : subscriptionsToDelete) {
                eventSubscriptionEntity.delete();
            }
        }
    }

    protected void addEventSubscriptions(ProcessDefinitionEntity processDefinition) {
        Map<String, EventSubscriptionDeclaration> eventDefinitions = processDefinition.getProperties().get(BpmnProperties.EVENT_SUBSCRIPTION_DECLARATIONS);
        for (EventSubscriptionDeclaration messageEventDefinition : eventDefinitions.values()) {
            this.addEventSubscription(processDefinition, messageEventDefinition);
        }
    }

    protected void addEventSubscription(ProcessDefinitionEntity processDefinition, EventSubscriptionDeclaration messageEventDefinition) {
        if (messageEventDefinition.isStartEvent()) {
            String eventType = messageEventDefinition.getEventType();
            if (eventType.equals("message")) {
                this.addMessageEventSubscription(messageEventDefinition, processDefinition);
            } else if (eventType.equals("signal")) {
                this.addSignalEventSubscription(messageEventDefinition, processDefinition);
            }
        }
    }

    protected void addMessageEventSubscription(EventSubscriptionDeclaration messageEventDefinition, ProcessDefinitionEntity processDefinition) {
        String tenantId = processDefinition.getTenantId();
        if (this.isSameMessageEventSubscriptionAlreadyPresent(messageEventDefinition, tenantId)) {
            throw LOG.messageEventSubscriptionWithSameNameExists(processDefinition.getResourceName(), messageEventDefinition.getEventName());
        }
        MessageEventSubscriptionEntity newSubscription = new MessageEventSubscriptionEntity();
        newSubscription.setEventName(messageEventDefinition.getEventName());
        newSubscription.setActivityId(messageEventDefinition.getActivityId());
        newSubscription.setConfiguration(processDefinition.getId());
        newSubscription.setTenantId(tenantId);
        newSubscription.insert();
    }

    protected boolean isSameMessageEventSubscriptionAlreadyPresent(EventSubscriptionDeclaration eventSubscription, String tenantId) {
        List<EventSubscriptionEntity> subscriptionsForSameMessageName = this.getEventSubscriptionManager().findEventSubscriptionsByNameAndTenantId("message", eventSubscription.getEventName(), tenantId);
        List<MessageEventSubscriptionEntity> cachedSubscriptions = this.getDbEntityManager().getCachedEntitiesByType(MessageEventSubscriptionEntity.class);
        for (MessageEventSubscriptionEntity cachedSubscription : cachedSubscriptions) {
            if (!eventSubscription.getEventName().equals(cachedSubscription.getEventName()) || !this.hasTenantId(cachedSubscription, tenantId) || subscriptionsForSameMessageName.contains(cachedSubscription)) continue;
            subscriptionsForSameMessageName.add(cachedSubscription);
        }
        subscriptionsForSameMessageName = this.getDbEntityManager().pruneDeletedEntities(subscriptionsForSameMessageName);
        return !(subscriptionsForSameMessageName = this.filterSubscriptionsOfDifferentType(eventSubscription, subscriptionsForSameMessageName)).isEmpty();
    }

    protected boolean hasTenantId(MessageEventSubscriptionEntity cachedSubscription, String tenantId) {
        if (tenantId == null) {
            return cachedSubscription.getTenantId() == null;
        }
        return tenantId.equals(cachedSubscription.getTenantId());
    }

    protected List<EventSubscriptionEntity> filterSubscriptionsOfDifferentType(EventSubscriptionDeclaration eventSubscription, List<EventSubscriptionEntity> subscriptionsForSameMessageName) {
        ArrayList<EventSubscriptionEntity> filteredSubscriptions = new ArrayList<EventSubscriptionEntity>(subscriptionsForSameMessageName);
        for (EventSubscriptionEntity subscriptionEntity : new ArrayList<EventSubscriptionEntity>(subscriptionsForSameMessageName)) {
            if (!this.isSubscriptionOfDifferentTypeAsDeclaration(subscriptionEntity, eventSubscription)) continue;
            filteredSubscriptions.remove(subscriptionEntity);
        }
        return filteredSubscriptions;
    }

    protected boolean isSubscriptionOfDifferentTypeAsDeclaration(EventSubscriptionEntity subscriptionEntity, EventSubscriptionDeclaration declaration) {
        return declaration.isStartEvent() && this.isSubscriptionForIntermediateEvent(subscriptionEntity) || !declaration.isStartEvent() && this.isSubscriptionForStartEvent(subscriptionEntity);
    }

    protected boolean isSubscriptionForStartEvent(EventSubscriptionEntity subscriptionEntity) {
        return subscriptionEntity.getExecutionId() == null;
    }

    protected boolean isSubscriptionForIntermediateEvent(EventSubscriptionEntity subscriptionEntity) {
        return subscriptionEntity.getExecutionId() != null;
    }

    protected void addSignalEventSubscription(EventSubscriptionDeclaration signalEventDefinition, ProcessDefinitionEntity processDefinition) {
        SignalEventSubscriptionEntity newSubscription = new SignalEventSubscriptionEntity();
        newSubscription.setEventName(signalEventDefinition.getEventName());
        newSubscription.setActivityId(signalEventDefinition.getActivityId());
        newSubscription.setConfiguration(processDefinition.getId());
        newSubscription.setTenantId(processDefinition.getTenantId());
        newSubscription.insert();
    }

    protected void addAuthorizationsFromIterator(Set<Expression> exprSet, ProcessDefinitionEntity processDefinition, ExprType exprType) {
        DbEntityManager dbEntityManager = this.getDbEntityManager();
        if (exprSet != null) {
            for (Expression expr : exprSet) {
                IdentityLinkEntity identityLink = new IdentityLinkEntity();
                identityLink.setProcessDef(processDefinition);
                if (exprType.equals((Object)ExprType.USER)) {
                    identityLink.setUserId(expr.toString());
                } else if (exprType.equals((Object)ExprType.GROUP)) {
                    identityLink.setGroupId(expr.toString());
                }
                identityLink.setType("candidate");
                identityLink.insert();
            }
        }
    }

    protected void addAuthorizations(ProcessDefinitionEntity processDefinition) {
        this.addAuthorizationsFromIterator(processDefinition.getCandidateStarterUserIdExpressions(), processDefinition, ExprType.USER);
        this.addAuthorizationsFromIterator(processDefinition.getCandidateStarterGroupIdExpressions(), processDefinition, ExprType.GROUP);
    }

    protected void createResource(String name, byte[] bytes, DeploymentEntity deploymentEntity) {
        ResourceEntity resource = new ResourceEntity();
        resource.setName(name);
        resource.setBytes(bytes);
        resource.setDeploymentId(deploymentEntity.getId());
        resource.setGenerated(true);
        this.getDbEntityManager().insert(resource);
    }

    protected DbEntityManager getDbEntityManager() {
        return this.getCommandContext().getDbEntityManager();
    }

    protected JobManager getJobManager() {
        return this.getCommandContext().getJobManager();
    }

    protected JobDefinitionManager getJobDefinitionManager() {
        return this.getCommandContext().getJobDefinitionManager();
    }

    protected EventSubscriptionManager getEventSubscriptionManager() {
        return this.getCommandContext().getEventSubscriptionManager();
    }

    protected ProcessDefinitionManager getProcessDefinitionManager() {
        return this.getCommandContext().getProcessDefinitionManager();
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    public BpmnParser getBpmnParser() {
        return this.bpmnParser;
    }

    public void setBpmnParser(BpmnParser bpmnParser) {
        this.bpmnParser = bpmnParser;
    }

    static enum ExprType {
        USER,
        GROUP;

    }
}

