/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.model.BaseCallableElement;
import org.camunda.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.camunda.bpm.engine.impl.dmn.invocation.DecisionTableInvocation;
import org.camunda.bpm.engine.impl.dmn.invocation.VariableScopeContext;
import org.camunda.bpm.engine.impl.dmn.result.CollectEntriesDecisionTableResultMapper;
import org.camunda.bpm.engine.impl.dmn.result.DecisionTableResultMapper;
import org.camunda.bpm.engine.impl.dmn.result.ResultListDecisionTableResultMapper;
import org.camunda.bpm.engine.impl.dmn.result.SingleEntryDecisionTableResultMapper;
import org.camunda.bpm.engine.impl.dmn.result.SingleResultDecisionTableResultMapper;
import org.camunda.bpm.engine.impl.util.CallableElementUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.context.VariableContext;

public class DecisionTableUtil {
    public static final String DECISION_RESULT_VARIABLE = "decisionResult";

    public static DecisionTableResultMapper getDecisionTableResultMapperForName(String mapDecisionResult) {
        if ("singleEntry".equals(mapDecisionResult)) {
            return new SingleEntryDecisionTableResultMapper();
        }
        if ("singleResult".equals(mapDecisionResult)) {
            return new SingleResultDecisionTableResultMapper();
        }
        if ("collectEntries".equals(mapDecisionResult)) {
            return new CollectEntriesDecisionTableResultMapper();
        }
        if ("resultList".equals(mapDecisionResult) || mapDecisionResult == null) {
            return new ResultListDecisionTableResultMapper();
        }
        return null;
    }

    public static void evaluateDecisionTable(AbstractVariableScope execution, BaseCallableElement callableElement, String resultVariable, DecisionTableResultMapper decisionTableResultMapper) throws Exception {
        DecisionDefinition decisionDefinition = DecisionTableUtil.resolveDecisionDefinition(callableElement, execution);
        DecisionTableInvocation invocation = DecisionTableUtil.createInvocation(decisionDefinition, execution);
        DecisionTableUtil.invoke(invocation);
        DmnDecisionTableResult result = invocation.getInvocationResult();
        if (result != null) {
            execution.setVariableLocalTransient(DECISION_RESULT_VARIABLE, result);
            if (resultVariable != null && decisionTableResultMapper != null) {
                Object mappedDecisionResult = decisionTableResultMapper.mapDecisionTableResult(result);
                execution.setVariable(resultVariable, mappedDecisionResult);
            }
        }
    }

    public static DmnDecisionTableResult evaluateDecisionTable(DecisionDefinition decisionDefinition, VariableMap variables) throws Exception {
        DecisionTableInvocation invocation = DecisionTableUtil.createInvocation(decisionDefinition, variables);
        DecisionTableUtil.invoke(invocation);
        return invocation.getInvocationResult();
    }

    protected static void invoke(DecisionTableInvocation invocation) throws Exception {
        Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
    }

    protected static DecisionTableInvocation createInvocation(DecisionDefinition decisionDefinition, VariableMap variables) {
        return DecisionTableUtil.createInvocation(decisionDefinition, variables.asVariableContext());
    }

    protected static DecisionTableInvocation createInvocation(DecisionDefinition decisionDefinition, AbstractVariableScope variableScope) {
        return DecisionTableUtil.createInvocation(decisionDefinition, VariableScopeContext.wrap(variableScope));
    }

    protected static DecisionTableInvocation createInvocation(DecisionDefinition decisionDefinition, VariableContext variableContext) {
        return new DecisionTableInvocation(decisionDefinition, variableContext);
    }

    protected static DecisionDefinition resolveDecisionDefinition(BaseCallableElement callableElement, AbstractVariableScope execution) {
        return CallableElementUtil.getDecisionDefinitionToCall(execution, callableElement);
    }
}

