/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.metrics;

import java.io.Serializable;
import java.util.Date;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.metrics.MetricsQueryType;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.management.MetricsQuery;

public class MetricsQueryImpl
implements Serializable,
Command<Object>,
MetricsQuery {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String reporter;
    protected Date startDate;
    protected Date endDate;
    protected MetricsQueryType queryType;
    protected transient CommandExecutor commandExecutor;

    public MetricsQueryImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public MetricsQueryImpl name(String name) {
        EnsureUtil.ensureNotNull("name", (Object)name);
        this.name = name;
        return this;
    }

    @Override
    public MetricsQuery reporter(String reporter) {
        EnsureUtil.ensureNotNull("reporter", (Object)reporter);
        this.reporter = reporter;
        return this;
    }

    @Override
    public MetricsQueryImpl startDate(Date startDate) {
        EnsureUtil.ensureNotNull("startDate", (Object)startDate);
        this.startDate = startDate;
        return this;
    }

    @Override
    public MetricsQueryImpl endDate(Date endDate) {
        EnsureUtil.ensureNotNull("endDate", (Object)endDate);
        this.endDate = endDate;
        return this;
    }

    @Override
    public long sum() {
        this.queryType = MetricsQueryType.SUM;
        return (Long)this.commandExecutor.execute(this);
    }

    @Override
    public Object execute(CommandContext commandContext) {
        switch (this.queryType) {
            case SUM: {
                return commandContext.getMeterLogManager().executeSelectSum(this);
            }
        }
        throw new ProcessEngineException("Incorrect query type. Must be one of " + MetricsQueryType.values());
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getName() {
        return this.name;
    }

    public String getReporter() {
        return this.reporter;
    }
}

