/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.commons.utils.EnsureUtil;

public class EventSubscriptionJobDeclaration
extends JobDeclaration<EventSubscriptionEntity, MessageEntity> {
    private static final long serialVersionUID = 1L;
    protected EventSubscriptionDeclaration eventSubscriptionDeclaration;

    public EventSubscriptionJobDeclaration(EventSubscriptionDeclaration eventSubscriptionDeclaration) {
        super("event");
        EnsureUtil.ensureNotNull((String)"eventSubscriptionDeclaration", (Object)eventSubscriptionDeclaration);
        this.eventSubscriptionDeclaration = eventSubscriptionDeclaration;
    }

    @Override
    protected MessageEntity newJobInstance(EventSubscriptionEntity eventSubscription) {
        MessageEntity message = new MessageEntity();
        message.setActivityId(eventSubscription.getActivityId());
        message.setExecutionId(eventSubscription.getExecutionId());
        message.setProcessInstanceId(eventSubscription.getProcessInstanceId());
        ProcessDefinitionEntity processDefinition = eventSubscription.getProcessDefinition();
        if (processDefinition != null) {
            message.setProcessDefinitionId(processDefinition.getId());
            message.setProcessDefinitionKey(processDefinition.getKey());
        }
        return message;
    }

    public String getEventType() {
        return this.eventSubscriptionDeclaration.getEventType();
    }

    public String getEventName() {
        return this.eventSubscriptionDeclaration.getEventName();
    }

    @Override
    public String getActivityId() {
        return this.eventSubscriptionDeclaration.getActivityId();
    }

    @Override
    protected ExecutionEntity resolveExecution(EventSubscriptionEntity context) {
        return context.getExecution();
    }

    @Override
    protected String resolveJobHandlerConfiguration(EventSubscriptionEntity context) {
        return context.getId();
    }

    public static List<EventSubscriptionJobDeclaration> getDeclarationsForActivity(PvmActivity activity) {
        Object result = activity.getProperty("eventJobDeclarations");
        if (result != null) {
            return (List)result;
        }
        return Collections.emptyList();
    }

    public static EventSubscriptionJobDeclaration findDeclarationForSubscription(EventSubscriptionEntity eventSubscription) {
        List<EventSubscriptionJobDeclaration> declarations = EventSubscriptionJobDeclaration.getDeclarationsForActivity(eventSubscription.getActivity());
        for (EventSubscriptionJobDeclaration declaration : declarations) {
            if (!declaration.getEventName().equals(eventSubscription.getEventName()) || !declaration.getEventType().equals(eventSubscription.getEventType())) continue;
            return declaration;
        }
        return null;
    }
}

