/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.ParameterValueProvider;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutorLogger;
import org.camunda.bpm.engine.impl.jobexecutor.JobPriorityProvider;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;

public class DefaultJobPriorityProvider
implements JobPriorityProvider {
    private static final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;
    public static long DEFAULT_PRIORITY = 0L;
    public static long DEFAULT_PRIORITY_ON_RESOLUTION_FAILURE = 0L;

    public long getDefaultPriority() {
        return DEFAULT_PRIORITY;
    }

    public long getDefaultPriorityOnResolutionFailure() {
        return DEFAULT_PRIORITY_ON_RESOLUTION_FAILURE;
    }

    @Override
    public long determinePriority(ExecutionEntity execution, JobDeclaration<?, ?> jobDeclaration) {
        Long jobDefinitionPriority = this.getJobDefinitionPriority(execution, jobDeclaration);
        if (jobDefinitionPriority != null) {
            return jobDefinitionPriority;
        }
        Long activityPriority = this.getActivityPriority(execution, jobDeclaration);
        if (activityPriority != null) {
            return activityPriority;
        }
        Long processDefinitionPriority = this.getProcessDefinitionPriority(execution, jobDeclaration);
        if (processDefinitionPriority != null) {
            return processDefinitionPriority;
        }
        return this.getDefaultPriority();
    }

    protected Long getJobDefinitionPriority(ExecutionEntity execution, JobDeclaration<?, ?> jobDeclaration) {
        JobDefinitionEntity jobDefinition = this.getJobDefinitionFor(jobDeclaration);
        if (jobDefinition != null) {
            return jobDefinition.getOverridingJobPriority();
        }
        return null;
    }

    protected Long getProcessDefinitionPriority(ExecutionEntity execution, JobDeclaration<?, ?> jobDeclaration) {
        ParameterValueProvider priorityProvider;
        ProcessDefinitionImpl processDefinition = jobDeclaration.getProcessDefinition();
        if (processDefinition != null && (priorityProvider = (ParameterValueProvider)processDefinition.getProperty("jobPriority")) != null) {
            return this.evaluateValueProvider(priorityProvider, execution, jobDeclaration);
        }
        return null;
    }

    protected JobDefinitionEntity getJobDefinitionFor(JobDeclaration<?, ?> jobDeclaration) {
        if (jobDeclaration.getJobDefinitionId() != null) {
            return Context.getCommandContext().getJobDefinitionManager().findById(jobDeclaration.getJobDefinitionId());
        }
        return null;
    }

    protected Long getActivityPriority(ExecutionEntity execution, JobDeclaration<?, ?> jobDeclaration) {
        ParameterValueProvider priorityProvider;
        if (jobDeclaration != null && (priorityProvider = jobDeclaration.getJobPriorityProvider()) != null) {
            return this.evaluateValueProvider(priorityProvider, execution, jobDeclaration);
        }
        return null;
    }

    protected Long evaluateValueProvider(ParameterValueProvider valueProvider, ExecutionEntity execution, JobDeclaration<?, ?> jobDeclaration) {
        Object value;
        try {
            value = valueProvider.getValue(execution);
        }
        catch (ProcessEngineException e) {
            if (Context.getProcessEngineConfiguration().isEnableGracefulDegradationOnContextSwitchFailure() && this.isSymptomOfContextSwitchFailure(e, execution)) {
                value = this.getDefaultPriorityOnResolutionFailure();
                LOG.couldNotDeterminePriority(execution, value, e);
            }
            throw e;
        }
        if (!(value instanceof Number)) {
            throw new ProcessEngineException(this.describeContext(jobDeclaration, execution) + ": Priority value is not an Integer");
        }
        Number numberValue = (Number)value;
        if (this.isValidLongValue(numberValue)) {
            return numberValue.longValue();
        }
        throw new ProcessEngineException(this.describeContext(jobDeclaration, execution) + ": Priority value must be either Short, Integer, or Long");
    }

    protected boolean isSymptomOfContextSwitchFailure(Throwable t, ExecutionEntity contextExecution) {
        return ProcessApplicationContextUtil.getTargetProcessApplication(contextExecution) == null;
    }

    protected String describeContext(JobDeclaration<?, ?> jobDeclaration, ExecutionEntity executionEntity) {
        return "Job " + jobDeclaration.getActivityId() + "/" + jobDeclaration.getJobHandlerType() + " instantiated " + "in context of " + executionEntity;
    }

    protected boolean isValidLongValue(Number value) {
        return value instanceof Short || value instanceof Integer || value instanceof Long;
    }
}

