/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.interceptor;

import org.apache.ibatis.exceptions.PersistenceException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.interceptor.Command;

public class CommandInvocationContext {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected Throwable throwable;
    protected Command<?> command;

    public CommandInvocationContext(Command<?> command) {
        this.command = command;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Command<?> getCommand() {
        return this.command;
    }

    public void trySetThrowable(Throwable t) {
        if (this.throwable == null) {
            this.throwable = t;
        } else {
            LOG.maskedExceptionInCommandContext(this.throwable);
        }
    }

    public void rethrow() {
        if (this.throwable != null) {
            if (this.throwable instanceof Error) {
                throw (Error)this.throwable;
            }
            if (this.throwable instanceof PersistenceException) {
                throw new ProcessEngineException("Process engine persistence exception", this.throwable);
            }
            if (this.throwable instanceof RuntimeException) {
                throw (RuntimeException)this.throwable;
            }
            throw new ProcessEngineException("exception while executing command " + this.command, this.throwable);
        }
    }
}

