/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.impl.cmd.CorrelateAllMessageCmd;
import org.camunda.bpm.engine.impl.cmd.CorrelateMessageCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.MessageCorrelationBuilder;
import org.camunda.bpm.engine.variable.impl.VariableMapImpl;

public class MessageCorrelationBuilderImpl
implements MessageCorrelationBuilder {
    protected CommandExecutor commandExecutor;
    protected CommandContext commandContext;
    protected boolean isExclusiveCorrelation = false;
    protected String messageName;
    protected String businessKey;
    protected String processInstanceId;
    protected Map<String, Object> correlationProcessInstanceVariables;
    protected Map<String, Object> payloadProcessInstanceVariables;

    public MessageCorrelationBuilderImpl(CommandExecutor commandExecutor, String messageName) {
        this(messageName);
        EnsureUtil.ensureNotNull("commandExecutor", (Object)commandExecutor);
        this.commandExecutor = commandExecutor;
    }

    public MessageCorrelationBuilderImpl(CommandContext commandContext, String messageName) {
        this(messageName);
        EnsureUtil.ensureNotNull("commandContext", (Object)commandContext);
        this.commandContext = commandContext;
    }

    private MessageCorrelationBuilderImpl(String messageName) {
        this.messageName = messageName;
    }

    @Override
    public MessageCorrelationBuilder processInstanceBusinessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Override
    public MessageCorrelationBuilder processInstanceVariableEquals(String variableName, Object variableValue) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        if (this.correlationProcessInstanceVariables == null) {
            this.correlationProcessInstanceVariables = new HashMap<String, Object>();
        }
        this.correlationProcessInstanceVariables.put(variableName, variableValue);
        return this;
    }

    @Override
    public MessageCorrelationBuilder processInstanceId(String id) {
        this.processInstanceId = id;
        return this;
    }

    @Override
    public MessageCorrelationBuilder setVariable(String variableName, Object variableValue) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        this.ensurePayloadProcessInstanceVariablesInitialized();
        this.payloadProcessInstanceVariables.put(variableName, variableValue);
        return this;
    }

    @Override
    public MessageCorrelationBuilder setVariables(Map<String, Object> variables) {
        if (variables != null) {
            this.ensurePayloadProcessInstanceVariablesInitialized();
            this.payloadProcessInstanceVariables.putAll(variables);
        }
        return this;
    }

    protected void ensurePayloadProcessInstanceVariablesInitialized() {
        if (this.payloadProcessInstanceVariables == null) {
            this.payloadProcessInstanceVariables = new VariableMapImpl();
        }
    }

    @Override
    public void correlate() {
        CorrelateMessageCmd command = new CorrelateMessageCmd(this);
        if (this.commandExecutor != null) {
            this.commandExecutor.execute(command);
        } else {
            command.execute(this.commandContext);
        }
    }

    @Override
    public void correlateExclusively() {
        this.isExclusiveCorrelation = true;
        this.correlate();
    }

    @Override
    public void correlateAll() {
        CorrelateAllMessageCmd command = new CorrelateAllMessageCmd(this);
        if (this.commandExecutor != null) {
            this.commandExecutor.execute(command);
        } else {
            command.execute(this.commandContext);
        }
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public CommandContext getCommandContext() {
        return this.commandContext;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public Map<String, Object> getCorrelationProcessInstanceVariables() {
        return this.correlationProcessInstanceVariables;
    }

    public Map<String, Object> getPayloadProcessInstanceVariables() {
        return this.payloadProcessInstanceVariables;
    }

    public boolean isExclusiveCorrelation() {
        return this.isExclusiveCorrelation;
    }
}

