/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;

public class ResourceManager
extends AbstractManager {
    public void insertResource(ResourceEntity resource) {
        this.getDbEntityManager().insert(resource);
    }

    public void deleteResourcesByDeploymentId(String deploymentId) {
        this.getDbEntityManager().delete(ResourceEntity.class, "deleteResourcesByDeploymentId", deploymentId);
    }

    public ResourceEntity findResourceByDeploymentIdAndResourceName(String deploymentId, String resourceName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("resourceName", resourceName);
        return (ResourceEntity)this.getDbEntityManager().selectOne("selectResourceByDeploymentIdAndResourceName", params);
    }

    public ResourceEntity findResourceByDeploymentIdAndResourceId(String deploymentId, String resourceId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("resourceId", resourceId);
        return (ResourceEntity)this.getDbEntityManager().selectOne("selectResourceByDeploymentIdAndResourceId", params);
    }

    public List<ResourceEntity> findResourcesByDeploymentId(String deploymentId) {
        return this.getDbEntityManager().selectList("selectResourcesByDeploymentId", deploymentId);
    }

    public Map<String, ResourceEntity> findLatestResourcesByDeploymentName(String deploymentName, Set<String> resourcesToFind) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("deploymentName", deploymentName);
        params.put("resourcesToFind", resourcesToFind);
        List resources = this.getDbEntityManager().selectList("selectLatestResourcesByDeploymentName", params);
        HashMap<String, ResourceEntity> existingResourcesByName = new HashMap<String, ResourceEntity>();
        for (ResourceEntity existingResource : resources) {
            existingResourcesByName.put(existingResource.getName(), existingResource);
        }
        return existingResourcesByName;
    }
}

