/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.impl.HistoricTaskInstanceQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class HistoricTaskInstanceManager
extends AbstractHistoricManager {
    public void deleteHistoricTaskInstancesByProcessInstanceId(String processInstanceId) {
        this.deleteHistoricTaskInstances("processInstanceId", processInstanceId);
    }

    public void deleteHistoricTaskInstancesByCaseInstanceId(String caseInstanceId) {
        this.deleteHistoricTaskInstances("caseInstanceId", caseInstanceId);
    }

    public void deleteHistoricTaskInstancesByCaseDefinitionId(String caseDefinitionId) {
        this.deleteHistoricTaskInstances("caseDefinitionId", caseDefinitionId);
    }

    protected void deleteHistoricTaskInstances(String key, String value) {
        if (this.isHistoryEnabled()) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(key, value);
            List taskInstanceIds = this.getDbEntityManager().selectList("selectHistoricTaskInstanceIdsByParameters", params);
            for (String taskInstanceId : taskInstanceIds) {
                this.deleteHistoricTaskInstanceById(taskInstanceId);
            }
        }
    }

    public long findHistoricTaskInstanceCountByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        if (this.isHistoryEnabled()) {
            this.getAuthorizationManager().configureHistoricTaskInstanceQuery(historicTaskInstanceQuery);
            return (Long)this.getDbEntityManager().selectOne("selectHistoricTaskInstanceCountByQueryCriteria", historicTaskInstanceQuery);
        }
        return 0L;
    }

    public List<HistoricTaskInstance> findHistoricTaskInstancesByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery, Page page) {
        if (this.isHistoryEnabled()) {
            this.getAuthorizationManager().configureHistoricTaskInstanceQuery(historicTaskInstanceQuery);
            return this.getDbEntityManager().selectList("selectHistoricTaskInstancesByQueryCriteria", historicTaskInstanceQuery, page);
        }
        return Collections.EMPTY_LIST;
    }

    public HistoricTaskInstanceEntity findHistoricTaskInstanceById(String taskId) {
        EnsureUtil.ensureNotNull("Invalid historic task id", "taskId", (Object)taskId);
        if (this.isHistoryEnabled()) {
            return (HistoricTaskInstanceEntity)this.getDbEntityManager().selectOne("selectHistoricTaskInstance", taskId);
        }
        return null;
    }

    public void deleteHistoricTaskInstanceById(String taskId) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryEnabled() && (historicTaskInstance = this.findHistoricTaskInstanceById(taskId)) != null) {
            CommandContext commandContext = Context.getCommandContext();
            commandContext.getHistoricDetailManager().deleteHistoricDetailsByTaskId(taskId);
            commandContext.getHistoricVariableInstanceManager().deleteHistoricVariableInstancesByTaskId(taskId);
            commandContext.getCommentManager().deleteCommentsByTaskId(taskId);
            commandContext.getAttachmentManager().deleteAttachmentsByTaskId(taskId);
            commandContext.getOperationLogManager().deleteOperationLogEntriesByTaskId(taskId);
            this.getDbEntityManager().delete(historicTaskInstance);
        }
    }

    public List<HistoricTaskInstance> findHistoricTaskInstancesByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbEntityManager().selectListWithRawParameter("selectHistoricTaskInstanceByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findHistoricTaskInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbEntityManager().selectOne("selectHistoricTaskInstanceCountByNativeQuery", parameterMap);
    }

    public void updateHistoricTaskInstance(TaskEntity taskEntity) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.TASK_INSTANCE_UPDATE, taskEntity)) {
            HistoryEventProducer eventProducer = configuration.getHistoryEventProducer();
            HistoryEventHandler eventHandler = configuration.getHistoryEventHandler();
            HistoryEvent evt = eventProducer.createTaskInstanceUpdateEvt(taskEntity);
            eventHandler.handleEvent(evt);
        }
    }

    public void markTaskInstanceEnded(String taskId, String deleteReason) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        TaskEntity taskEntity = Context.getCommandContext().getDbEntityManager().selectById(TaskEntity.class, taskId);
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.TASK_INSTANCE_COMPLETE, taskEntity)) {
            HistoryEventProducer eventProducer = configuration.getHistoryEventProducer();
            HistoryEventHandler eventHandler = configuration.getHistoryEventHandler();
            HistoryEvent evt = eventProducer.createTaskInstanceCompleteEvt(taskEntity, deleteReason);
            eventHandler.handleEvent(evt);
        }
    }

    public void createHistoricTask(TaskEntity task) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.TASK_INSTANCE_CREATE, task)) {
            HistoryEventProducer eventProducer = configuration.getHistoryEventProducer();
            HistoryEventHandler eventHandler = configuration.getHistoryEventHandler();
            HistoryEvent evt = eventProducer.createTaskInstanceCreateEvt(task);
            eventHandler.handleEvent(evt);
        }
    }
}

