/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.ExecutionQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public class ExecutionManager
extends AbstractManager {
    public void insertExecution(ExecutionEntity execution) {
        this.getDbEntityManager().insert(execution);
        this.createDefaultAuthorizations(execution);
    }

    public void deleteExecution(ExecutionEntity execution) {
        this.getDbEntityManager().delete(execution);
        if (execution.isProcessInstanceExecution()) {
            this.deleteAuthorizations(Resources.PROCESS_INSTANCE, execution.getProcessInstanceId());
        }
    }

    public void deleteProcessInstancesByProcessDefinition(String processDefinitionId, String deleteReason, boolean cascade, boolean skipCustomListeners) {
        List processInstanceIds = this.getDbEntityManager().selectList("selectProcessInstanceIdsByProcessDefinitionId", processDefinitionId);
        for (String processInstanceId : processInstanceIds) {
            this.deleteProcessInstance(processInstanceId, deleteReason, cascade, skipCustomListeners);
        }
        if (cascade) {
            this.getHistoricProcessInstanceManager().deleteHistoricProcessInstanceByProcessDefinitionId(processDefinitionId);
        }
    }

    public void deleteProcessInstance(String processInstanceId, String deleteReason) {
        this.deleteProcessInstance(processInstanceId, deleteReason, false, false);
    }

    public void deleteProcessInstance(String processInstanceId, String deleteReason, boolean cascade, boolean skipCustomListeners) {
        ExecutionEntity execution = this.findExecutionById(processInstanceId);
        if (execution == null) {
            throw new BadUserRequestException("No process instance found for id '" + processInstanceId + "'");
        }
        this.getTaskManager().deleteTasksByProcessInstanceId(processInstanceId, deleteReason, cascade);
        execution.deleteCascade(deleteReason, skipCustomListeners);
        if (cascade) {
            this.getHistoricProcessInstanceManager().deleteHistoricProcessInstanceById(processInstanceId);
        }
    }

    public ExecutionEntity findSubProcessInstanceBySuperExecutionId(String superExecutionId) {
        return (ExecutionEntity)this.getDbEntityManager().selectOne("selectSubProcessInstanceBySuperExecutionId", superExecutionId);
    }

    public ExecutionEntity findSubProcessInstanceBySuperCaseExecutionId(String superCaseExecutionId) {
        return (ExecutionEntity)this.getDbEntityManager().selectOne("selectSubProcessInstanceBySuperCaseExecutionId", superCaseExecutionId);
    }

    public List<ExecutionEntity> findChildExecutionsByParentExecutionId(String parentExecutionId) {
        return this.getDbEntityManager().selectList("selectExecutionsByParentExecutionId", parentExecutionId);
    }

    public List<ExecutionEntity> findChildExecutionsByProcessInstanceId(String processInstanceId) {
        return this.getDbEntityManager().selectList("selectExecutionsByProcessInstanceId", processInstanceId);
    }

    public ExecutionEntity findExecutionById(String executionId) {
        return this.getDbEntityManager().selectById(ExecutionEntity.class, executionId);
    }

    public long findExecutionCountByQueryCriteria(ExecutionQueryImpl executionQuery) {
        this.configureAuthorizationCheck(executionQuery);
        return (Long)this.getDbEntityManager().selectOne("selectExecutionCountByQueryCriteria", executionQuery);
    }

    public List<ExecutionEntity> findExecutionsByQueryCriteria(ExecutionQueryImpl executionQuery, Page page) {
        this.configureAuthorizationCheck(executionQuery);
        return this.getDbEntityManager().selectList("selectExecutionsByQueryCriteria", executionQuery, page);
    }

    public long findProcessInstanceCountByQueryCriteria(ProcessInstanceQueryImpl processInstanceQuery) {
        this.configureAuthorizationCheck(processInstanceQuery);
        return (Long)this.getDbEntityManager().selectOne("selectProcessInstanceCountByQueryCriteria", processInstanceQuery);
    }

    public List<ProcessInstance> findProcessInstanceByQueryCriteria(ProcessInstanceQueryImpl processInstanceQuery, Page page) {
        this.configureAuthorizationCheck(processInstanceQuery);
        return this.getDbEntityManager().selectList("selectProcessInstanceByQueryCriteria", processInstanceQuery, page);
    }

    public List<ExecutionEntity> findEventScopeExecutionsByActivityId(String activityRef, String parentExecutionId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("activityId", activityRef);
        parameters.put("parentExecutionId", parentExecutionId);
        return this.getDbEntityManager().selectList("selectExecutionsByParentExecutionId", parameters);
    }

    public List<Execution> findExecutionsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbEntityManager().selectListWithRawParameter("selectExecutionByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public List<ProcessInstance> findProcessInstanceByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbEntityManager().selectListWithRawParameter("selectExecutionByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findExecutionCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbEntityManager().selectOne("selectExecutionCountByNativeQuery", parameterMap);
    }

    public void updateExecutionSuspensionStateByProcessDefinitionId(String processDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(ExecutionEntity.class, "updateExecutionSuspensionStateByParameters", parameters);
    }

    public void updateExecutionSuspensionStateByProcessInstanceId(String processInstanceId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(ExecutionEntity.class, "updateExecutionSuspensionStateByParameters", parameters);
    }

    public void updateExecutionSuspensionStateByProcessDefinitionKey(String processDefinitionKey, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(ExecutionEntity.class, "updateExecutionSuspensionStateByParameters", parameters);
    }

    protected void createDefaultAuthorizations(ExecutionEntity execution) {
        if (execution.isProcessInstanceExecution() && this.isAuthorizationEnabled()) {
            ResourceAuthorizationProvider provider = this.getResourceAuthorizationProvider();
            AuthorizationEntity[] authorizations = provider.newProcessInstance(execution);
            this.saveDefaultAuthorizations(authorizations);
        }
    }

    protected void configureAuthorizationCheck(AbstractQuery<?, ?> query) {
        this.getAuthorizationManager().configureExecutionQuery(query);
    }
}

