/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.parser.ErrorEventDefinition;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.SubProcessActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.tree.Collector;
import org.camunda.bpm.engine.impl.tree.FlowScopeWalker;
import org.camunda.bpm.engine.impl.tree.TreeWalker;

public class AbstractBpmnActivityBehavior
extends FlowNodeActivityBehavior {
    private static final Logger LOG = Logger.getLogger(AbstractBpmnActivityBehavior.class.getName());

    @Override
    protected void leave(ActivityExecution execution) {
        PvmActivity currentActivity = execution.getActivity();
        ActivityImpl compensationHandler = this.getCompensationHandler(currentActivity);
        if (compensationHandler != null) {
            this.createCompensateEventSubscription(execution, compensationHandler);
        }
        super.leave(execution);
    }

    protected ActivityImpl getCompensationHandler(PvmActivity activity) {
        String compensationHandlerId = (String)activity.getProperty("compensationHandler");
        if (compensationHandlerId != null) {
            return (ActivityImpl)activity.getProcessDefinition().findActivity(compensationHandlerId);
        }
        return null;
    }

    protected void createCompensateEventSubscription(ActivityExecution execution, ActivityImpl compensationHandler) {
        PvmActivity currentActivity = execution.getActivity();
        PvmScope levelOfSubprocessScope = currentActivity.getLevelOfSubprocessScope();
        ActivityExecution levelOfSubprocessScopeExecution = execution.findExecutionForFlowScope(levelOfSubprocessScope);
        CompensateEventSubscriptionEntity.createAndInsert((ExecutionEntity)levelOfSubprocessScopeExecution, compensationHandler);
    }

    protected void propagateExceptionAsError(Exception exception, ActivityExecution execution) throws Exception {
        if (this.isProcessEngineExceptionWithoutCause(exception) || this.isTransactionNotActive()) {
            throw exception;
        }
        this.propagateError(null, exception, execution);
    }

    protected boolean isTransactionNotActive() {
        return !Context.getCommandContext().getTransactionContext().isTransactionActive();
    }

    protected boolean isProcessEngineExceptionWithoutCause(Exception exception) {
        return exception instanceof ProcessEngineException && exception.getCause() == null;
    }

    protected void propagateBpmnError(BpmnError error, ActivityExecution execution) throws Exception {
        this.propagateError(error.getErrorCode(), null, execution);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void propagateError(String errorCode, Exception origException, ActivityExecution execution) throws Exception {
        LeafExecutionHierarchyWalker scopeHierarchyWalker = new LeafExecutionHierarchyWalker((PvmExecutionImpl)execution);
        ErrorDeclarationFinder errorDeclarationFinder = new ErrorDeclarationFinder(origException, errorCode);
        ProcessInstanceCollector processInstanceCollector = new ProcessInstanceCollector();
        scopeHierarchyWalker.addPreCollector(errorDeclarationFinder);
        scopeHierarchyWalker.addPreCollector(processInstanceCollector);
        scopeHierarchyWalker.walkUntil(errorDeclarationFinder.declarationFound());
        ActivityImpl errorHandlingActivity = errorDeclarationFinder.getErrorHandlerActivity();
        ErrorEventDefinition errorDefinition = errorDeclarationFinder.getErrorEventDefinition();
        PvmExecutionImpl errorHandlingExecution = errorDeclarationFinder.getErrorHandlingExecution();
        List<PvmExecutionImpl> processInstanceHierarchy = processInstanceCollector.getProcessInstanceHierarchy();
        for (int i = 0; i < processInstanceHierarchy.size() - 1; ++i) {
            PvmExecutionImpl processInstance = processInstanceHierarchy.get(i);
            PvmExecutionImpl superExecution = processInstance.getSuperExecution();
            ActivityImpl activity = superExecution.getActivity();
            SubProcessActivityBehavior subProcessActivityBehavior = (SubProcessActivityBehavior)activity.getActivityBehavior();
            subProcessActivityBehavior.completing(superExecution, processInstance);
        }
        if (errorHandlingExecution == null) {
            if (origException != null) throw origException;
            LOG.info(execution.getActivity().getId() + " throws error event with errorCode '" + errorCode + "', but no catching boundary event was defined. " + "Execution is ended (none end event semantics).");
            execution.end(true);
            return;
        } else {
            if (errorDefinition.getErrorCodeVariable() != null) {
                errorHandlingExecution.setVariable(errorDefinition.getErrorCodeVariable(), errorCode);
            }
            errorHandlingExecution.executeActivity(errorHandlingActivity);
        }
    }

    protected static ScopeImpl getCurrentFlowScope(ActivityExecution execution) {
        ScopeImpl scope = null;
        scope = execution.getTransition() != null ? execution.getTransition().getDestination().getFlowScope() : (ScopeImpl)((Object)execution.getActivity());
        scope = scope.isScope() ? scope : scope.getFlowScope();
        return scope;
    }

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        if ("compensationDone".equals(signalName)) {
            this.signalCompensationDone(execution, signalData);
        } else {
            super.signal(execution, signalName, signalData);
        }
    }

    protected void signalCompensationDone(ActivityExecution execution, Object signalData) {
        if (execution.getExecutions().isEmpty()) {
            if (execution.getParent() != null) {
                ActivityExecution parent = execution.getParent();
                execution.remove();
                parent.signal("compensationDone", signalData);
            }
        } else {
            ((ExecutionEntity)execution).forceUpdate();
        }
    }

    public static class ProcessInstanceCollector
    implements Collector<PvmExecutionImpl> {
        protected List<PvmExecutionImpl> processInstanceHierarchy = new ArrayList<PvmExecutionImpl>();

        @Override
        public void collect(PvmExecutionImpl obj) {
            this.processInstanceHierarchy.add(obj.getProcessInstance());
        }

        public List<PvmExecutionImpl> getProcessInstanceHierarchy() {
            return this.processInstanceHierarchy;
        }
    }

    public static class ErrorDeclarationForProcessInstanceFinder
    implements Collector<ScopeImpl> {
        protected Exception exception;
        protected String errorCode;
        protected ActivityImpl errorHandlerActivity;
        protected ErrorEventDefinition errorEventDefinition;

        public ErrorDeclarationForProcessInstanceFinder(Exception exception, String errorCode) {
            this.exception = exception;
            this.errorCode = errorCode;
        }

        public TreeWalker.WalkCondition<ScopeImpl> declarationFound() {
            return new TreeWalker.WalkCondition<ScopeImpl>(){

                @Override
                public boolean isFulfilled(ScopeImpl element) {
                    return element == null || ErrorDeclarationForProcessInstanceFinder.this.errorHandlerActivity != null;
                }
            };
        }

        @Override
        public void collect(ScopeImpl scope) {
            List errorEventDefinitions = (List)scope.getProperty("errorEventDefinitions");
            if (errorEventDefinitions != null) {
                for (ErrorEventDefinition errorEventDefinition : errorEventDefinitions) {
                    if ((this.exception == null || !errorEventDefinition.catchesException(this.exception)) && (this.exception != null || !errorEventDefinition.catchesError(this.errorCode))) continue;
                    this.errorHandlerActivity = scope.getProcessDefinition().findActivity(errorEventDefinition.getHandlerActivityId());
                    this.errorEventDefinition = errorEventDefinition;
                    break;
                }
            }
        }

        public ActivityImpl getErrorHandlerActivity() {
            return this.errorHandlerActivity;
        }

        public ErrorEventDefinition getErrorEventDefinition() {
            return this.errorEventDefinition;
        }
    }

    public static class ErrorDeclarationFinder
    implements Collector<PvmExecutionImpl> {
        protected Exception exception;
        protected String errorCode;
        protected ErrorDeclarationForProcessInstanceFinder currentProcessInstanceErrorFinder;
        protected Map<ScopeImpl, PvmExecutionImpl> currentProcessInstanceScopeExecutionMapping;

        public ErrorDeclarationFinder(Exception exception, String errorCode) {
            this.exception = exception;
            this.errorCode = errorCode;
        }

        public TreeWalker.WalkCondition<PvmExecutionImpl> declarationFound() {
            return new TreeWalker.WalkCondition<PvmExecutionImpl>(){

                @Override
                public boolean isFulfilled(PvmExecutionImpl element) {
                    return element == null || ErrorDeclarationFinder.this.currentProcessInstanceErrorFinder.getErrorHandlerActivity() != null;
                }
            };
        }

        @Override
        public void collect(PvmExecutionImpl obj) {
            this.currentProcessInstanceScopeExecutionMapping = obj.createActivityExecutionMapping();
            ScopeImpl flowScope = AbstractBpmnActivityBehavior.getCurrentFlowScope(obj);
            FlowScopeWalker flowScopeWalker = new FlowScopeWalker(flowScope);
            this.currentProcessInstanceErrorFinder = new ErrorDeclarationForProcessInstanceFinder(this.exception, this.errorCode);
            flowScopeWalker.addPreCollector(this.currentProcessInstanceErrorFinder);
            flowScopeWalker.walkWhile(this.currentProcessInstanceErrorFinder.declarationFound());
        }

        public ActivityImpl getErrorHandlerActivity() {
            return this.currentProcessInstanceErrorFinder.getErrorHandlerActivity();
        }

        public PvmExecutionImpl getErrorHandlingExecution() {
            ActivityImpl errorHandlingActivity = this.getErrorHandlerActivity();
            if (errorHandlingActivity != null) {
                return this.currentProcessInstanceScopeExecutionMapping.get(errorHandlingActivity.getEventScope());
            }
            return null;
        }

        public ErrorEventDefinition getErrorEventDefinition() {
            return this.currentProcessInstanceErrorFinder.getErrorEventDefinition();
        }
    }

    public static class LeafExecutionHierarchyWalker
    extends TreeWalker<PvmExecutionImpl> {
        public LeafExecutionHierarchyWalker(PvmExecutionImpl initialElement) {
            super(initialElement);
        }

        @Override
        protected PvmExecutionImpl nextElement() {
            return ((PvmExecutionImpl)this.currentElement).getProcessInstance().getSuperExecution();
        }
    }
}

