/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.Map;
import org.camunda.bpm.engine.impl.ProcessInstanceModificationBuilderImpl;
import org.camunda.bpm.engine.impl.cmd.StartProcessInstanceAtActivitiesCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;

public class ProcessInstantiationBuilderImpl
implements ProcessInstantiationBuilder {
    protected CommandExecutor commandExecutor;
    protected CommandContext commandContext;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String businessKey;
    protected String caseInstanceId;
    protected ProcessInstanceModificationBuilderImpl modificationBuilder;

    public ProcessInstantiationBuilderImpl(String processDefinitionId, String processDefinitionKey) {
        EnsureUtil.ensureOnlyOneNotNull("either process definition id or key must be set", processDefinitionId, processDefinitionKey);
        this.processDefinitionId = processDefinitionId;
        this.processDefinitionKey = processDefinitionKey;
        this.modificationBuilder = new ProcessInstanceModificationBuilderImpl();
    }

    public ProcessInstantiationBuilderImpl(CommandExecutor commandExecutor, String processDefinitionId, String processDefinitionKey) {
        this(processDefinitionId, processDefinitionKey);
        this.commandExecutor = commandExecutor;
    }

    public ProcessInstantiationBuilderImpl(CommandContext commandContext, String processDefinitionId, String processDefinitionKey) {
        this(processDefinitionId, processDefinitionKey);
        this.commandContext = commandContext;
    }

    @Override
    public ProcessInstantiationBuilder startBeforeActivity(String activityId) {
        this.modificationBuilder.startBeforeActivity(activityId);
        return this;
    }

    @Override
    public ProcessInstantiationBuilder startAfterActivity(String activityId) {
        this.modificationBuilder.startAfterActivity(activityId);
        return this;
    }

    @Override
    public ProcessInstantiationBuilder startTransition(String transitionId) {
        this.modificationBuilder.startTransition(transitionId);
        return this;
    }

    @Override
    public ProcessInstantiationBuilder setVariable(String name, Object value) {
        this.modificationBuilder.setVariable(name, value);
        return this;
    }

    @Override
    public ProcessInstantiationBuilder setVariableLocal(String name, Object value) {
        this.modificationBuilder.setVariableLocal(name, value);
        return this;
    }

    @Override
    public ProcessInstantiationBuilder setVariables(Map<String, Object> variables) {
        this.modificationBuilder.setVariables((Map)variables);
        return this;
    }

    @Override
    public ProcessInstantiationBuilder setVariablesLocal(Map<String, Object> variables) {
        this.modificationBuilder.setVariablesLocal((Map)variables);
        return this;
    }

    @Override
    public ProcessInstantiationBuilder businessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Override
    public ProcessInstantiationBuilder caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Override
    public ProcessInstance execute() {
        return this.execute(false, false);
    }

    @Override
    public ProcessInstance execute(boolean skipCustomListeners, boolean skipIoMappings) {
        this.modificationBuilder.setSkipCustomListeners(skipCustomListeners);
        this.modificationBuilder.setSkipIoMappings(skipIoMappings);
        StartProcessInstanceAtActivitiesCmd cmd = new StartProcessInstanceAtActivitiesCmd(this);
        if (this.commandExecutor != null) {
            return this.commandExecutor.execute(cmd);
        }
        return cmd.execute(this.commandContext);
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public ProcessInstanceModificationBuilderImpl getModificationBuilder() {
        return this.modificationBuilder;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }
}

