/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime.operation;

import java.util.List;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.ExecutionStartContext;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperationActivityInstanceStart;

public class PvmAtomicOperationActivityInitStackNotifyListenerStart
extends PvmAtomicOperationActivityInstanceStart {
    @Override
    public String getCanonicalName() {
        return "activity-init-stack-notify-listener-start";
    }

    @Override
    protected ScopeImpl getScope(PvmExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        if (activity != null) {
            return activity;
        }
        PvmExecutionImpl parent = execution.getParent();
        if (parent != null) {
            return this.getScope(execution.getParent());
        }
        return execution.getProcessDefinition();
    }

    @Override
    protected String getEventName() {
        return "start";
    }

    @Override
    protected void eventNotificationsCompleted(PvmExecutionImpl execution) {
        super.eventNotificationsCompleted(execution);
        ExecutionStartContext startContext = execution.getExecutionStartContext();
        List<PvmActivity> activityStack = startContext.getActivityStack();
        PvmActivity currentActivity = activityStack.get(0);
        if (activityStack.size() == 1) {
            startContext.applyVariables(execution);
            execution.setActivity(currentActivity);
            execution.performOperation(ACTIVITY_START_CREATE_SCOPE);
        } else {
            execution.setActivity(null);
            execution.performOperation(ACTIVITY_INIT_STACK);
        }
    }
}

