/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;

public class ExecutionStartContext {
    protected List<PvmActivity> activityStack;
    protected Map<String, Object> variables;
    protected Map<String, Object> variablesLocal;

    public void executionStarted(CoreExecution execution) {
        if (execution instanceof ExecutionEntity) {
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            executionEntity.fireHistoricVariableInstanceCreateEvents();
            for (ExecutionEntity parent = executionEntity; parent != null && parent.getExecutionStartContext() != null; parent = parent.getParent()) {
                parent.disposeExecutionStartContext();
            }
        }
    }

    public void applyVariables(CoreExecution execution) {
        execution.setVariables(this.variables);
        execution.setVariablesLocal(this.variablesLocal);
    }

    public List<PvmActivity> getActivityStack() {
        return this.activityStack;
    }

    public void setActivityStack(List<PvmActivity> activityStack) {
        this.activityStack = activityStack;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public void setVariablesLocal(Map<String, Object> variablesLocal) {
        this.variablesLocal = variablesLocal;
    }
}

