/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.interceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.TaskAlreadyClaimedException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.TransactionContext;
import org.camunda.bpm.engine.impl.cfg.TransactionContextFactory;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionManager;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionManager;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseSentryPartManager;
import org.camunda.bpm.engine.impl.cmmn.operation.CmmnAtomicOperation;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.db.sql.DbSqlSession;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.impl.identity.ReadOnlyIdentityProvider;
import org.camunda.bpm.engine.impl.identity.WritableIdentityProvider;
import org.camunda.bpm.engine.impl.interceptor.CommandContextListener;
import org.camunda.bpm.engine.impl.interceptor.CommandInvocationContext;
import org.camunda.bpm.engine.impl.interceptor.Session;
import org.camunda.bpm.engine.impl.interceptor.SessionFactory;
import org.camunda.bpm.engine.impl.jobexecutor.FailedJobCommandFactory;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentManager;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayManager;
import org.camunda.bpm.engine.impl.persistence.entity.CommentManager;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentManager;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.FilterManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricActivityInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricCaseActivityInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricCaseInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricDetailManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricStatisticsManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricTaskInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceManager;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityInfoManager;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityLinkManager;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyManager;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceManager;
import org.camunda.bpm.engine.impl.persistence.entity.StatisticsManager;
import org.camunda.bpm.engine.impl.persistence.entity.TableDataManager;
import org.camunda.bpm.engine.impl.persistence.entity.TaskManager;
import org.camunda.bpm.engine.impl.persistence.entity.UserOperationLogManager;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceManager;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperation;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class CommandContext {
    private static Logger log = Logger.getLogger(CommandContext.class.getName());
    protected TransactionContext transactionContext;
    protected Map<Class<?>, SessionFactory> sessionFactories;
    protected Map<Class<?>, Session> sessions = new HashMap();
    protected List<Session> sessionList = new ArrayList<Session>();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected FailedJobCommandFactory failedJobCommandFactory;
    protected List<CommandContextListener> commandContextListeners = new LinkedList<CommandContextListener>();

    public CommandContext(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this(processEngineConfiguration, processEngineConfiguration.getTransactionContextFactory());
    }

    public CommandContext(ProcessEngineConfigurationImpl processEngineConfiguration, TransactionContextFactory transactionContextFactory) {
        this.processEngineConfiguration = processEngineConfiguration;
        this.failedJobCommandFactory = processEngineConfiguration.getFailedJobCommandFactory();
        this.sessionFactories = processEngineConfiguration.getSessionFactories();
        this.transactionContext = transactionContextFactory.openTransactionContext(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performOperation(final AtomicOperation executionOperation, final ExecutionEntity execution) {
        ProcessApplicationReference targetProcessApplication = this.getTargetProcessApplication(execution);
        if (this.requiresContextSwitch(targetProcessApplication)) {
            Context.executeWithinProcessApplication(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    CommandContext.this.performOperation(executionOperation, execution);
                    return null;
                }
            }, targetProcessApplication);
        } else {
            try {
                Context.setExecutionContext(execution);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("AtomicOperation: " + executionOperation + " on " + this);
                }
                executionOperation.execute(execution);
            }
            finally {
                Context.removeExecutionContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performOperation(final CmmnAtomicOperation executionOperation, final CaseExecutionEntity execution) {
        ProcessApplicationReference targetProcessApplication = this.getTargetProcessApplication(execution);
        if (this.requiresContextSwitch(targetProcessApplication)) {
            Context.executeWithinProcessApplication(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    CommandContext.this.performOperation(executionOperation, execution);
                    return null;
                }
            }, targetProcessApplication);
        } else {
            try {
                Context.setExecutionContext(execution);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("AtomicOperation: " + executionOperation + " on " + this);
                }
                executionOperation.execute(execution);
            }
            finally {
                Context.removeExecutionContext();
            }
        }
    }

    protected ProcessApplicationReference getTargetProcessApplication(ExecutionEntity execution) {
        return ProcessApplicationContextUtil.getTargetProcessApplication(execution);
    }

    protected ProcessApplicationReference getTargetProcessApplication(CaseExecutionEntity execution) {
        return ProcessApplicationContextUtil.getTargetProcessApplication(execution);
    }

    protected boolean requiresContextSwitch(ProcessApplicationReference processApplicationReference) {
        return ProcessApplicationContextUtil.requiresContextSwitch(processApplicationReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close(CommandInvocationContext commandInvocationContext) {
        block31: {
            try {
                try {
                    try {
                        if (commandInvocationContext.getThrowable() == null) {
                            this.fireCommandContextClose();
                            this.flushSessions();
                        }
                    }
                    catch (Throwable exception) {
                        try {
                            commandInvocationContext.trySetThrowable(exception);
                            break block31;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                if (commandInvocationContext.getThrowable() == null) {
                                    this.transactionContext.commit();
                                }
                            }
                            catch (Throwable exception2) {
                                commandInvocationContext.trySetThrowable(exception2);
                            }
                            if (commandInvocationContext.getThrowable() != null) {
                                this.fireCommandFailed(commandInvocationContext.getThrowable());
                                Level loggingLevel = Level.SEVERE;
                                if (this.shouldLogInfo(commandInvocationContext.getThrowable())) {
                                    loggingLevel = Level.INFO;
                                } else if (this.shouldLogFine(commandInvocationContext.getThrowable())) {
                                    loggingLevel = Level.FINE;
                                }
                                if (log.isLoggable(loggingLevel)) {
                                    log.log(loggingLevel, "Error while closing command context", commandInvocationContext.getThrowable());
                                }
                                this.transactionContext.rollback();
                            }
                        }
                    }
                    try {
                        if (commandInvocationContext.getThrowable() == null) {
                            this.transactionContext.commit();
                        }
                    }
                    catch (Throwable exception) {
                        commandInvocationContext.trySetThrowable(exception);
                    }
                    if (commandInvocationContext.getThrowable() != null) {
                        this.fireCommandFailed(commandInvocationContext.getThrowable());
                        Level loggingLevel = Level.SEVERE;
                        if (this.shouldLogInfo(commandInvocationContext.getThrowable())) {
                            loggingLevel = Level.INFO;
                        } else if (this.shouldLogFine(commandInvocationContext.getThrowable())) {
                            loggingLevel = Level.FINE;
                        }
                        if (log.isLoggable(loggingLevel)) {
                            log.log(loggingLevel, "Error while closing command context", commandInvocationContext.getThrowable());
                        }
                        this.transactionContext.rollback();
                    }
                }
                catch (Throwable exception) {
                    commandInvocationContext.trySetThrowable(exception);
                }
                finally {
                    this.closeSessions(commandInvocationContext);
                }
            }
            catch (Throwable exception) {
                commandInvocationContext.trySetThrowable(exception);
            }
        }
        commandInvocationContext.rethrow();
    }

    protected boolean shouldLogInfo(Throwable exception) {
        return exception instanceof TaskAlreadyClaimedException;
    }

    protected boolean shouldLogFine(Throwable exception) {
        return exception instanceof OptimisticLockingException || exception instanceof BadUserRequestException;
    }

    protected void fireCommandContextClose() {
        for (CommandContextListener listener : this.commandContextListeners) {
            listener.onCommandContextClose(this);
        }
    }

    protected void fireCommandFailed(Throwable t) {
        for (CommandContextListener listener : this.commandContextListeners) {
            try {
                listener.onCommandFailed(this, t);
            }
            catch (Throwable ex) {
                log.log(Level.SEVERE, "Exception while invoking onCommandFailed()", t);
            }
        }
    }

    protected void flushSessions() {
        for (int i = 0; i < this.sessionList.size(); ++i) {
            this.sessionList.get(i).flush();
        }
    }

    protected void closeSessions(CommandInvocationContext commandInvocationContext) {
        for (Session session : this.sessionList) {
            try {
                session.close();
            }
            catch (Throwable exception) {
                commandInvocationContext.trySetThrowable(exception);
            }
        }
    }

    public <T> T getSession(Class<T> sessionClass) {
        Session session = this.sessions.get(sessionClass);
        if (session == null) {
            SessionFactory sessionFactory = this.sessionFactories.get(sessionClass);
            EnsureUtil.ensureNotNull("no session factory configured for " + sessionClass.getName(), "sessionFactory", (Object)sessionFactory);
            session = sessionFactory.openSession();
            this.sessions.put(sessionClass, session);
            this.sessionList.add(0, session);
        }
        return (T)session;
    }

    public DbEntityManager getDbEntityManager() {
        return this.getSession(DbEntityManager.class);
    }

    public DbSqlSession getDbSqlSession() {
        return this.getSession(DbSqlSession.class);
    }

    public DeploymentManager getDeploymentManager() {
        return this.getSession(DeploymentManager.class);
    }

    public ResourceManager getResourceManager() {
        return this.getSession(ResourceManager.class);
    }

    public ByteArrayManager getByteArrayManager() {
        return this.getSession(ByteArrayManager.class);
    }

    public ProcessDefinitionManager getProcessDefinitionManager() {
        return this.getSession(ProcessDefinitionManager.class);
    }

    public ExecutionManager getExecutionManager() {
        return this.getSession(ExecutionManager.class);
    }

    public TaskManager getTaskManager() {
        return this.getSession(TaskManager.class);
    }

    public IdentityLinkManager getIdentityLinkManager() {
        return this.getSession(IdentityLinkManager.class);
    }

    public VariableInstanceManager getVariableInstanceManager() {
        return this.getSession(VariableInstanceManager.class);
    }

    public HistoricProcessInstanceManager getHistoricProcessInstanceManager() {
        return this.getSession(HistoricProcessInstanceManager.class);
    }

    public HistoricCaseInstanceManager getHistoricCaseInstanceManager() {
        return this.getSession(HistoricCaseInstanceManager.class);
    }

    public HistoricDetailManager getHistoricDetailManager() {
        return this.getSession(HistoricDetailManager.class);
    }

    public UserOperationLogManager getOperationLogManager() {
        return this.getSession(UserOperationLogManager.class);
    }

    public HistoricVariableInstanceManager getHistoricVariableInstanceManager() {
        return this.getSession(HistoricVariableInstanceManager.class);
    }

    public HistoricActivityInstanceManager getHistoricActivityInstanceManager() {
        return this.getSession(HistoricActivityInstanceManager.class);
    }

    public HistoricCaseActivityInstanceManager getHistoricCaseActivityInstanceManager() {
        return this.getSession(HistoricCaseActivityInstanceManager.class);
    }

    public HistoricTaskInstanceManager getHistoricTaskInstanceManager() {
        return this.getSession(HistoricTaskInstanceManager.class);
    }

    public HistoricIncidentManager getHistoricIncidentManager() {
        return this.getSession(HistoricIncidentManager.class);
    }

    public JobManager getJobManager() {
        return this.getSession(JobManager.class);
    }

    public JobDefinitionManager getJobDefinitionManager() {
        return this.getSession(JobDefinitionManager.class);
    }

    public IncidentManager getIncidentManager() {
        return this.getSession(IncidentManager.class);
    }

    public IdentityInfoManager getIdentityInfoManager() {
        return this.getSession(IdentityInfoManager.class);
    }

    public AttachmentManager getAttachmentManager() {
        return this.getSession(AttachmentManager.class);
    }

    public TableDataManager getTableDataManager() {
        return this.getSession(TableDataManager.class);
    }

    public CommentManager getCommentManager() {
        return this.getSession(CommentManager.class);
    }

    public EventSubscriptionManager getEventSubscriptionManager() {
        return this.getSession(EventSubscriptionManager.class);
    }

    public Map<Class<?>, SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    public PropertyManager getPropertyManager() {
        return this.getSession(PropertyManager.class);
    }

    public StatisticsManager getStatisticsManager() {
        return this.getSession(StatisticsManager.class);
    }

    public HistoricStatisticsManager getHistoricStatisticsManager() {
        return this.getSession(HistoricStatisticsManager.class);
    }

    public HistoricJobLogManager getHistoricJobLogManager() {
        return this.getSession(HistoricJobLogManager.class);
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.getSession(AuthorizationManager.class);
    }

    public ReadOnlyIdentityProvider getReadOnlyIdentityProvider() {
        return this.getSession(ReadOnlyIdentityProvider.class);
    }

    public WritableIdentityProvider getWritableIdentityProvider() {
        return this.getSession(WritableIdentityProvider.class);
    }

    public CaseDefinitionManager getCaseDefinitionManager() {
        return this.getSession(CaseDefinitionManager.class);
    }

    public CaseExecutionManager getCaseExecutionManager() {
        return this.getSession(CaseExecutionManager.class);
    }

    public CaseSentryPartManager getCaseSentryPartManager() {
        return this.getSession(CaseSentryPartManager.class);
    }

    public FilterManager getFilterManager() {
        return this.getSession(FilterManager.class);
    }

    public void registerCommandContextListener(CommandContextListener commandContextListener) {
        if (!this.commandContextListeners.contains(commandContextListener)) {
            this.commandContextListeners.add(commandContextListener);
        }
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public Map<Class<?>, Session> getSessions() {
        return this.sessions;
    }

    public FailedJobCommandFactory getFailedJobCommandFactory() {
        return this.failedJobCommandFactory;
    }

    public Authentication getAuthentication() {
        IdentityService identityService = this.processEngineConfiguration.getIdentityService();
        return identityService.getCurrentAuthentication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithoutAuthentication(Runnable runnable) {
        IdentityService identityService = this.processEngineConfiguration.getIdentityService();
        Authentication currentAuthentication = identityService.getCurrentAuthentication();
        try {
            identityService.clearAuthentication();
            runnable.run();
        }
        finally {
            identityService.setAuthentication(currentAuthentication);
        }
    }

    public String getAuthenticatedUserId() {
        IdentityService identityService = this.processEngineConfiguration.getIdentityService();
        Authentication currentAuthentication = identityService.getCurrentAuthentication();
        if (currentAuthentication == null) {
            return null;
        }
        return currentAuthentication.getUserId();
    }

    public List<String> getAuthenticatedGroupIds() {
        IdentityService identityService = this.processEngineConfiguration.getIdentityService();
        Authentication currentAuthentication = identityService.getCurrentAuthentication();
        if (currentAuthentication == null) {
            return null;
        }
        return currentAuthentication.getGroupIds();
    }
}

