/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class RemoveTaskVariablesCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String taskId;
    private final Collection<String> variableNames;
    private final boolean isLocal;

    public RemoveTaskVariablesCmd(String taskId, Collection<String> variableNames, boolean isLocal) {
        this.taskId = taskId;
        this.variableNames = variableNames;
        this.isLocal = isLocal;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("taskId", (Object)this.taskId);
        TaskEntity task = commandContext.getTaskManager().findTaskById(this.taskId);
        EnsureUtil.ensureNotNull("Cannot find task with id " + this.taskId, "task", (Object)task);
        if (this.isLocal) {
            task.removeVariablesLocal(this.variableNames);
        } else {
            task.removeVariables(this.variableNames);
        }
        return null;
    }
}

