/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ActivityExecutionMapping;
import org.camunda.bpm.engine.impl.ActivityInstantiationInstruction;
import org.camunda.bpm.engine.impl.ProcessInstanceModificationBuilderImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class ModifyProcessInstanceCmd
implements Command<Void> {
    protected ProcessInstanceModificationBuilderImpl builder;

    public ModifyProcessInstanceCmd(ProcessInstanceModificationBuilderImpl processInstanceModificationBuilder) {
        this.builder = processInstanceModificationBuilder;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        String processInstanceId = this.builder.getProcessInstanceId();
        ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(processInstanceId);
        ProcessDefinitionImpl processDefinition = processInstance.getProcessDefinition();
        for (ActivityInstantiationInstruction startInstruction : this.builder.getActivitiesToStartBefore()) {
            ActivityImpl activity = processDefinition.findActivity(startInstruction.getActivityId());
            EnsureUtil.ensureNotNull("activity", (Object)activity);
            ActivityExecutionMapping mapping = new ActivityExecutionMapping(commandContext, processInstanceId);
            ArrayList<PvmActivity> activitiesToInstantiate = new ArrayList<PvmActivity>();
            activitiesToInstantiate.add(activity);
            ScopeImpl flowScope = activity.getFlowScope();
            Set<ExecutionEntity> flowScopeExecutions = mapping.getExecutions(flowScope);
            while (flowScopeExecutions.isEmpty()) {
                ActivityImpl flowScopeActivity = (ActivityImpl)flowScope;
                activitiesToInstantiate.add(flowScopeActivity);
                flowScope = flowScopeActivity.getFlowScope();
                flowScopeExecutions = mapping.getExecutions(flowScope);
            }
            if (flowScopeExecutions.size() > 1) {
                throw new ProcessEngineException("Execution is ambiguous for activity " + flowScope);
            }
            Collections.reverse(activitiesToInstantiate);
            ExecutionEntity scopeExecution = flowScopeExecutions.iterator().next();
            ActivityImpl topMostActivity = (ActivityImpl)activitiesToInstantiate.get(0);
            boolean isCancelScope = false;
            if (topMostActivity.isCancelScope()) {
                if (activitiesToInstantiate.size() > 1) {
                    ActivityImpl initialActivity = (ActivityImpl)topMostActivity.getProperty("initial");
                    if (initialActivity == activitiesToInstantiate.get(1)) {
                        isCancelScope = true;
                    }
                } else {
                    isCancelScope = true;
                }
            }
            if (isCancelScope) {
                ScopeImpl scopeToCancel = topMostActivity.getParentScope();
                Set<ExecutionEntity> executionsToCancel = mapping.getExecutions(scopeToCancel);
                if (!executionsToCancel.isEmpty()) {
                    if (executionsToCancel.size() > 1) {
                        throw new ProcessEngineException("Execution to cancel/interrupt is ambiguous for activity " + topMostActivity);
                    }
                    ExecutionEntity interruptedExecution = executionsToCancel.iterator().next();
                    if (scopeToCancel == topMostActivity.getFlowScope()) {
                        interruptedExecution.cancelScope("Interrupting event sub process " + topMostActivity + " fired.");
                        interruptedExecution.executeActivities(activitiesToInstantiate, startInstruction.getVariables(), startInstruction.getVariablesLocal());
                        continue;
                    }
                    scopeExecution.cancelScope("Cancel scope activity " + topMostActivity + " executed.");
                    scopeExecution.executeActivities(activitiesToInstantiate, startInstruction.getVariables(), startInstruction.getVariablesLocal());
                    continue;
                }
                scopeExecution.executeActivitiesConcurrent(activitiesToInstantiate, startInstruction.getVariables(), startInstruction.getVariablesLocal());
                continue;
            }
            scopeExecution.executeActivitiesConcurrent(activitiesToInstantiate, startInstruction.getVariables(), startInstruction.getVariablesLocal());
        }
        return null;
    }
}

