/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.ExecutionQueryImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ActivityInstanceImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessElementInstanceImpl;
import org.camunda.bpm.engine.impl.persistence.entity.TransitionInstanceImpl;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.TransitionInstance;

public class GetActivityInstanceCmd
implements Command<ActivityInstance> {
    protected String processInstanceId;

    public GetActivityInstanceCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public ActivityInstance execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("processInstanceId", (Object)this.processInstanceId);
        List<ExecutionEntity> executionList = this.loadProcessInstance(this.processInstanceId, commandContext);
        if (executionList.isEmpty()) {
            return null;
        }
        ExecutionEntity processInstance = null;
        HashMap<String, List<ExecutionEntity>> executionsByParentActIds = new HashMap<String, List<ExecutionEntity>>();
        for (ExecutionEntity executionEntity : executionList) {
            String parentActivityInstanceId;
            ArrayList<ExecutionEntity> exeForThisParentActInst;
            if (executionEntity.isProcessInstanceExecution()) {
                processInstance = executionEntity;
            }
            if ((exeForThisParentActInst = (ArrayList<ExecutionEntity>)executionsByParentActIds.get(parentActivityInstanceId = executionEntity.getParentActivityInstanceId())) == null) {
                exeForThisParentActInst = new ArrayList<ExecutionEntity>();
                executionsByParentActIds.put(parentActivityInstanceId, exeForThisParentActInst);
            }
            exeForThisParentActInst.add(executionEntity);
        }
        ActivityInstanceImpl processActInst = new ActivityInstanceImpl();
        processActInst.setId(this.processInstanceId);
        processActInst.setParentActivityInstanceId(null);
        processActInst.setProcessInstanceId(this.processInstanceId);
        processActInst.setProcessDefinitionId(processInstance.getProcessDefinitionId());
        processActInst.setExecutionIds(new String[]{this.processInstanceId});
        processActInst.setBusinessKey(processInstance.getBusinessKey());
        processActInst.setActivityId(processInstance.getProcessDefinitionId());
        processActInst.setActivityName(processInstance.getProcessDefinition().getName());
        processActInst.setBusinessKey(processInstance.getBusinessKey());
        processActInst.setActivityType("processDefinition");
        this.initActivityInstanceTree(processActInst, executionsByParentActIds);
        return processActInst;
    }

    protected List<ExecutionEntity> loadProcessInstance(String processInstanceId, CommandContext commandContext) {
        List<ExecutionEntity> result = null;
        List<ExecutionEntity> cachedExecutions = commandContext.getDbEntityManager().getCachedEntitiesByType(ExecutionEntity.class);
        for (ExecutionEntity executionEntity : cachedExecutions) {
            if (!processInstanceId.equals(executionEntity.getProcessInstanceId())) continue;
            result = new ArrayList<ExecutionEntity>();
            ExecutionEntity processInstance = executionEntity.getProcessInstance();
            result.add(processInstance);
            this.loadChildExecutionsFromCache(processInstance, result);
            break;
        }
        if (result == null) {
            result = this.loadFromDb(processInstanceId, commandContext);
        }
        return result;
    }

    protected List<ExecutionEntity> loadFromDb(String processInstanceId, CommandContext commandContext) {
        return new ExecutionQueryImpl(commandContext).processInstanceId(processInstanceId).list();
    }

    protected void loadChildExecutionsFromCache(ExecutionEntity execution, List<ExecutionEntity> childExecutions) {
        List<ExecutionEntity> childrenOfThisExecution = execution.getExecutions();
        if (childrenOfThisExecution != null) {
            childExecutions.addAll(childrenOfThisExecution);
            for (ExecutionEntity child : childrenOfThisExecution) {
                this.loadChildExecutionsFromCache(child, childExecutions);
            }
        }
    }

    protected void initActivityInstanceTree(ActivityInstanceImpl parentActInst, Map<String, List<ExecutionEntity>> executionsByParentActIds) {
        HashMap<String, ActivityInstanceImpl> childActivityInstances = new HashMap<String, ActivityInstanceImpl>();
        ArrayList<TransitionInstanceImpl> childTransitionInstances = new ArrayList<TransitionInstanceImpl>();
        List<ExecutionEntity> childExecutions = executionsByParentActIds.get(parentActInst.getId());
        if (childExecutions == null) {
            return;
        }
        for (ExecutionEntity execution : childExecutions) {
            Object type;
            if (execution.getActivityInstanceId() == null) {
                TransitionInstanceImpl transitionInstance = new TransitionInstanceImpl();
                this.initProcessElementInstance(transitionInstance, parentActInst, execution);
                transitionInstance.setId(execution.getId());
                transitionInstance.setExecutionId(execution.getId());
                transitionInstance.setTargetActivityId(execution.getActivityId());
                childTransitionInstances.add(transitionInstance);
                continue;
            }
            if (this.isInactiveConcurrentRoot(execution) || execution.getActivityInstanceId().equals(parentActInst.getId())) continue;
            ActivityInstanceImpl activityInstance = (ActivityInstanceImpl)childActivityInstances.get(execution.getActivityInstanceId());
            if (activityInstance != null) {
                String[] executionIds = activityInstance.getExecutionIds();
                executionIds = Arrays.copyOf(executionIds, executionIds.length + 1);
                executionIds[executionIds.length] = execution.getId();
                activityInstance.setExecutionIds(executionIds);
                continue;
            }
            ActivityInstanceImpl actInstance = new ActivityInstanceImpl();
            this.initProcessElementInstance(actInstance, parentActInst, execution);
            actInstance.setBusinessKey(execution.getBusinessKey());
            actInstance.setExecutionIds(new String[]{execution.getId()});
            ScopeImpl activity = GetActivityInstanceCmd.getActivity(execution);
            actInstance.setActivityId(activity.getId());
            Object name = activity.getProperty("name");
            if (name != null) {
                actInstance.setActivityName((String)name);
            }
            if ((type = activity.getProperty("type")) != null) {
                actInstance.setActivityType((String)type);
            }
            childActivityInstances.put(actInstance.getId(), actInstance);
        }
        parentActInst.setChildActivityInstances(childActivityInstances.values().toArray(new ActivityInstance[0]));
        parentActInst.setChildTransitionInstances(childTransitionInstances.toArray(new TransitionInstance[0]));
        for (ActivityInstance childActInstance : parentActInst.getChildActivityInstances()) {
            this.initActivityInstanceTree((ActivityInstanceImpl)childActInstance, executionsByParentActIds);
        }
    }

    private void initProcessElementInstance(ProcessElementInstanceImpl inst, ActivityInstance parentActInst, ExecutionEntity execution) {
        inst.setId(execution.getActivityInstanceId());
        inst.setParentActivityInstanceId(parentActInst.getId());
        inst.setProcessInstanceId(parentActInst.getProcessInstanceId());
        inst.setProcessDefinitionId(parentActInst.getProcessDefinitionId());
    }

    protected boolean isInactiveConcurrentRoot(ExecutionEntity execution) {
        List<ExecutionEntity> executions = execution.getExecutions();
        return execution.isScope() && !executions.isEmpty() && executions.get(0).isConcurrent() && !execution.isActive();
    }

    public static ScopeImpl getActivity(ExecutionEntity executionEntity) {
        if (executionEntity.getActivityId() != null) {
            return executionEntity.getActivity();
        }
        int i = 0;
        while (!executionEntity.getExecutions().isEmpty()) {
            ExecutionEntity childExecution = executionEntity.getExecutions().get(0);
            if (!executionEntity.getActivityInstanceId().equals(childExecution.getActivityInstanceId())) {
                ++i;
            }
            executionEntity = childExecution;
        }
        ActivityImpl scope = executionEntity.getActivity();
        for (int j = 0; j < i; ++j) {
            if (scope.getParentActivity() == null) continue;
            scope = scope.getParentActivity();
        }
        return scope;
    }
}

