/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.ArrayList;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.QueryEntityRelationCondition;
import org.camunda.bpm.engine.impl.QueryOrderingProperty;
import org.camunda.bpm.engine.impl.TaskQueryProperty;
import org.camunda.bpm.engine.impl.VariableInstanceQueryProperty;
import org.camunda.bpm.engine.query.QueryProperty;
import org.camunda.bpm.engine.variable.type.ValueType;

public class VariableOrderProperty
extends QueryOrderingProperty {
    private static final long serialVersionUID = 1L;

    public VariableOrderProperty(String name, ValueType valueType) {
        super("variable", VariableOrderProperty.typeToQueryProperty(valueType));
        this.relationConditions = new ArrayList();
        this.relationConditions.add(new QueryEntityRelationCondition(VariableInstanceQueryProperty.VARIABLE_NAME, name));
        this.relationConditions.add(new QueryEntityRelationCondition(VariableInstanceQueryProperty.VARIABLE_TYPE, valueType.getName()));
    }

    public static VariableOrderProperty forProcessInstanceVariable(String variableName, ValueType valueType) {
        VariableOrderProperty orderingProperty = new VariableOrderProperty(variableName, valueType);
        orderingProperty.relationConditions.add(new QueryEntityRelationCondition(VariableInstanceQueryProperty.EXECUTION_ID, TaskQueryProperty.PROCESS_INSTANCE_ID));
        return orderingProperty;
    }

    public static VariableOrderProperty forExecutionVariable(String variableName, ValueType valueType) {
        VariableOrderProperty orderingProperty = new VariableOrderProperty(variableName, valueType);
        orderingProperty.relationConditions.add(new QueryEntityRelationCondition(VariableInstanceQueryProperty.EXECUTION_ID, TaskQueryProperty.EXECUTION_ID));
        return orderingProperty;
    }

    public static VariableOrderProperty forTaskVariable(String variableName, ValueType valueType) {
        VariableOrderProperty orderingProperty = new VariableOrderProperty(variableName, valueType);
        orderingProperty.relationConditions.add(new QueryEntityRelationCondition(VariableInstanceQueryProperty.TASK_ID, TaskQueryProperty.TASK_ID));
        return orderingProperty;
    }

    public static VariableOrderProperty forCaseInstanceVariable(String variableName, ValueType valueType) {
        VariableOrderProperty orderingProperty = new VariableOrderProperty(variableName, valueType);
        orderingProperty.relationConditions.add(new QueryEntityRelationCondition(VariableInstanceQueryProperty.CASE_EXECUTION_ID, TaskQueryProperty.CASE_INSTANCE_ID));
        return orderingProperty;
    }

    public static VariableOrderProperty forCaseExecutionVariable(String variableName, ValueType valueType) {
        VariableOrderProperty orderingProperty = new VariableOrderProperty(variableName, valueType);
        orderingProperty.relationConditions.add(new QueryEntityRelationCondition(VariableInstanceQueryProperty.CASE_EXECUTION_ID, TaskQueryProperty.CASE_EXECUTION_ID));
        return orderingProperty;
    }

    public static QueryProperty typeToQueryProperty(ValueType type) {
        if (ValueType.STRING.equals(type)) {
            return VariableInstanceQueryProperty.TEXT_AS_LOWER;
        }
        if (ValueType.INTEGER.equals(type)) {
            return VariableInstanceQueryProperty.LONG;
        }
        if (ValueType.SHORT.equals(type)) {
            return VariableInstanceQueryProperty.LONG;
        }
        if (ValueType.DATE.equals(type)) {
            return VariableInstanceQueryProperty.LONG;
        }
        if (ValueType.BOOLEAN.equals(type)) {
            return VariableInstanceQueryProperty.LONG;
        }
        if (ValueType.LONG.equals(type)) {
            return VariableInstanceQueryProperty.LONG;
        }
        if (ValueType.DOUBLE.equals(type)) {
            return VariableInstanceQueryProperty.DOUBLE;
        }
        if (ValueType.DATE.equals(type)) {
            return VariableInstanceQueryProperty.LONG;
        }
        throw new ProcessEngineException("Cannot order by variables of type " + type.getName());
    }
}

