/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricJobLogQuery;
import org.camunda.bpm.engine.history.JobState;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.HistoricJobLogQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class HistoricJobLogQueryImpl
extends AbstractQuery<HistoricJobLogQuery, HistoricJobLog>
implements HistoricJobLogQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String jobId;
    protected String jobExceptionMessage;
    protected String jobDefinitionId;
    protected String jobDefinitionType;
    protected String jobDefinitionConfiguration;
    protected String[] activityIds;
    protected String[] executionIds;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String deploymentId;
    protected JobState state;

    public HistoricJobLogQueryImpl() {
    }

    public HistoricJobLogQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public HistoricJobLogQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public HistoricJobLogQuery logId(String historicJobLogId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "historicJobLogId", (Object)historicJobLogId);
        this.id = historicJobLogId;
        return this;
    }

    @Override
    public HistoricJobLogQuery jobId(String jobId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "jobId", (Object)jobId);
        this.jobId = jobId;
        return this;
    }

    @Override
    public HistoricJobLogQuery jobExceptionMessage(String jobExceptionMessage) {
        EnsureUtil.ensureNotNull(NotValidException.class, "jobExceptionMessage", (Object)jobExceptionMessage);
        this.jobExceptionMessage = jobExceptionMessage;
        return this;
    }

    @Override
    public HistoricJobLogQuery jobDefinitionId(String jobDefinitionId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "jobDefinitionId", (Object)jobDefinitionId);
        this.jobDefinitionId = jobDefinitionId;
        return this;
    }

    @Override
    public HistoricJobLogQuery jobDefinitionType(String jobDefinitionType) {
        EnsureUtil.ensureNotNull(NotValidException.class, "jobDefinitionType", (Object)jobDefinitionType);
        this.jobDefinitionType = jobDefinitionType;
        return this;
    }

    @Override
    public HistoricJobLogQuery jobDefinitionConfiguration(String jobDefinitionConfiguration) {
        EnsureUtil.ensureNotNull(NotValidException.class, "jobDefinitionConfiguration", (Object)jobDefinitionConfiguration);
        this.jobDefinitionConfiguration = jobDefinitionConfiguration;
        return this;
    }

    @Override
    public HistoricJobLogQuery activityIdIn(String ... activityIds) {
        List<String> activityIdList = Arrays.asList(activityIds);
        EnsureUtil.ensureNotContainsNull("activityIds", activityIdList);
        EnsureUtil.ensureNotContainsEmptyString("activityIds", activityIdList);
        this.activityIds = activityIds;
        return this;
    }

    @Override
    public HistoricJobLogQuery executionIdIn(String ... executionIds) {
        List<String> executionIdList = Arrays.asList(executionIds);
        EnsureUtil.ensureNotContainsNull("executionIds", executionIdList);
        EnsureUtil.ensureNotContainsEmptyString("executionIds", executionIdList);
        this.executionIds = executionIds;
        return this;
    }

    @Override
    public HistoricJobLogQuery processInstanceId(String processInstanceId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "processInstanceId", (Object)processInstanceId);
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public HistoricJobLogQuery processDefinitionId(String processDefinitionId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "processDefinitionId", (Object)processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public HistoricJobLogQuery processDefinitionKey(String processDefinitionKey) {
        EnsureUtil.ensureNotNull(NotValidException.class, "processDefinitionKey", (Object)processDefinitionKey);
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public HistoricJobLogQuery deploymentId(String deploymentId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "deploymentId", (Object)deploymentId);
        this.deploymentId = deploymentId;
        return this;
    }

    @Override
    public HistoricJobLogQuery creationLog() {
        this.setState(JobState.CREATED);
        return this;
    }

    @Override
    public HistoricJobLogQuery failureLog() {
        this.setState(JobState.FAILED);
        return this;
    }

    @Override
    public HistoricJobLogQuery successLog() {
        this.setState(JobState.SUCCESSFUL);
        return this;
    }

    @Override
    public HistoricJobLogQuery deletionLog() {
        this.setState(JobState.DELETED);
        return this;
    }

    @Override
    public HistoricJobLogQuery orderByTimestamp() {
        this.orderBy(HistoricJobLogQueryProperty.TIMESTAMP);
        return this;
    }

    @Override
    public HistoricJobLogQuery orderByJobId() {
        this.orderBy(HistoricJobLogQueryProperty.JOB_ID);
        return this;
    }

    @Override
    public HistoricJobLogQuery orderByJobDueDate() {
        this.orderBy(HistoricJobLogQueryProperty.DUEDATE);
        return this;
    }

    @Override
    public HistoricJobLogQuery orderByJobRetries() {
        this.orderBy(HistoricJobLogQueryProperty.RETRIES);
        return this;
    }

    @Override
    public HistoricJobLogQuery orderByJobDefinitionId() {
        this.orderBy(HistoricJobLogQueryProperty.JOB_DEFINITION_ID);
        return this;
    }

    @Override
    public HistoricJobLogQuery orderByActivityId() {
        this.orderBy(HistoricJobLogQueryProperty.ACTIVITY_ID);
        return this;
    }

    @Override
    public HistoricJobLogQuery orderByExecutionId() {
        this.orderBy(HistoricJobLogQueryProperty.EXECUTION_ID);
        return this;
    }

    @Override
    public HistoricJobLogQuery orderByProcessInstanceId() {
        this.orderBy(HistoricJobLogQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricJobLogQuery orderByProcessDefinitionId() {
        this.orderBy(HistoricJobLogQueryProperty.PROCESS_DEFINITION_ID);
        return this;
    }

    @Override
    public HistoricJobLogQuery orderByProcessDefinitionKey() {
        this.orderBy(HistoricJobLogQueryProperty.PROCESS_DEFINITION_KEY);
        return this;
    }

    @Override
    public HistoricJobLogQuery orderByDeploymentId() {
        this.orderBy(HistoricJobLogQueryProperty.DEPLOYMENT_ID);
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getHistoricJobLogManager().findHistoricJobLogsCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricJobLog> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getHistoricJobLogManager().findHistoricJobLogsByQueryCriteria(this, page);
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getJobExceptionMessage() {
        return this.jobExceptionMessage;
    }

    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    public String getJobDefinitionType() {
        return this.jobDefinitionType;
    }

    public String getJobDefinitionConfiguration() {
        return this.jobDefinitionConfiguration;
    }

    public String[] getActivityIds() {
        return this.activityIds;
    }

    public String[] getExecutionIds() {
        return this.executionIds;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public JobState getState() {
        return this.state;
    }

    protected void setState(JobState state) {
        this.state = state;
    }
}

