/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class ActivityExecutionMapping {
    protected Map<ScopeImpl, Set<ExecutionEntity>> activityExecutionMapping;
    protected CommandContext commandContext;
    protected String processInstanceId;

    public ActivityExecutionMapping(CommandContext commandContext, String processInstanceId) {
        this.commandContext = commandContext;
        this.processInstanceId = processInstanceId;
        this.activityExecutionMapping = new HashMap<ScopeImpl, Set<ExecutionEntity>>();
        this.initialize();
    }

    public Set<ExecutionEntity> getExecutions(ScopeImpl activity) {
        Set<ExecutionEntity> executionsForActivity = this.activityExecutionMapping.get(activity);
        if (executionsForActivity == null) {
            executionsForActivity = new HashSet<ExecutionEntity>();
            this.activityExecutionMapping.put(activity, executionsForActivity);
        }
        return executionsForActivity;
    }

    protected void initialize() {
        ExecutionEntity processInstance = this.commandContext.getExecutionManager().findExecutionById(this.processInstanceId);
        List<ExecutionEntity> executions = this.fetchExecutionsForProcessInstance(processInstance);
        executions.add(processInstance);
        List<ExecutionEntity> leaves = this.findLeaves(executions);
        this.assignExecutionsToActivities(leaves);
    }

    protected void assignExecutionsToActivities(List<ExecutionEntity> leaves) {
        for (ExecutionEntity leaf : leaves) {
            ActivityImpl activity = leaf.getActivity();
            this.assignToActivity(leaf, activity);
        }
    }

    protected void assignToActivity(ExecutionEntity execution, ScopeImpl activity) {
        EnsureUtil.ensureNotNull("activityId", (Object)activity);
        Set<ExecutionEntity> executionsForActivity = this.getExecutions(activity);
        executionsForActivity.add(execution);
        if (execution.isProcessInstanceExecution()) {
            Set<ExecutionEntity> executionsForProcessDefinition = this.getExecutions(activity.getProcessDefinition());
            executionsForProcessDefinition.add(execution);
        } else if (!activity.isScope() && execution.isScope()) {
            this.assignToActivity(execution, activity.getParentScope());
        } else {
            ExecutionEntity parent = execution.getParent();
            if (!parent.isScope()) {
                parent = parent.getParent();
            }
            this.assignToActivity(parent, activity.getParentScope());
        }
    }

    protected List<ExecutionEntity> fetchExecutionsForProcessInstance(ExecutionEntity execution) {
        ArrayList<ExecutionEntity> executions = new ArrayList<ExecutionEntity>();
        executions.addAll(execution.getExecutions());
        for (ExecutionEntity child : execution.getExecutions()) {
            executions.addAll(this.fetchExecutionsForProcessInstance(child));
        }
        return executions;
    }

    protected List<ExecutionEntity> findLeaves(List<ExecutionEntity> executions) {
        ArrayList<ExecutionEntity> leaves = new ArrayList<ExecutionEntity>();
        for (ExecutionEntity execution : executions) {
            if (!execution.getExecutions().isEmpty()) continue;
            leaves.add(execution);
        }
        return leaves;
    }
}

