/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.deployment.scanning;

import java.net.URL;
import java.util.Map;
import org.camunda.bpm.container.impl.deployment.scanning.ClassPathProcessApplicationScanner;
import org.camunda.bpm.container.impl.deployment.scanning.VfsProcessApplicationScanner;
import org.camunda.bpm.container.impl.deployment.scanning.spi.ProcessApplicationScanner;
import org.camunda.bpm.engine.impl.bpmn.deployer.BpmnDeployer;
import org.camunda.bpm.engine.impl.cmmn.deployer.CmmnDeployer;

public class ProcessApplicationScanningUtil {
    public static Map<String, byte[]> findResources(ClassLoader classLoader, String paResourceRootPath, URL metaFileUrl) {
        return ProcessApplicationScanningUtil.findResources(classLoader, paResourceRootPath, metaFileUrl, null);
    }

    public static Map<String, byte[]> findResources(ClassLoader classLoader, String paResourceRootPath, URL metaFileUrl, String[] additionalResourceSuffixes) {
        ProcessApplicationScanner scanner = null;
        try {
            classLoader.loadClass("org.jboss.vfs.VFS");
            scanner = new VfsProcessApplicationScanner();
        }
        catch (Throwable t) {
            scanner = new ClassPathProcessApplicationScanner();
        }
        return scanner.findResources(classLoader, paResourceRootPath, metaFileUrl, additionalResourceSuffixes);
    }

    public static boolean isDeployable(String filename) {
        return ProcessApplicationScanningUtil.hasSuffix(filename, BpmnDeployer.BPMN_RESOURCE_SUFFIXES) || ProcessApplicationScanningUtil.hasSuffix(filename, CmmnDeployer.CMMN_RESOURCE_SUFFIXES);
    }

    public static boolean isDeployable(String filename, String[] additionalResourceSuffixes) {
        return ProcessApplicationScanningUtil.isDeployable(filename) || ProcessApplicationScanningUtil.hasSuffix(filename, additionalResourceSuffixes);
    }

    public static boolean hasSuffix(String filename, String[] suffixes) {
        if (suffixes == null || suffixes.length == 0) {
            return false;
        }
        for (String suffix : suffixes) {
            if (!filename.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDiagram(String fileName, String modelFileName) {
        boolean isBpmnDiagram = ProcessApplicationScanningUtil.checkDiagram(fileName, modelFileName, BpmnDeployer.DIAGRAM_SUFFIXES, BpmnDeployer.BPMN_RESOURCE_SUFFIXES);
        boolean isCmmnDiagram = ProcessApplicationScanningUtil.checkDiagram(fileName, modelFileName, CmmnDeployer.DIAGRAM_SUFFIXES, CmmnDeployer.CMMN_RESOURCE_SUFFIXES);
        return isBpmnDiagram || isCmmnDiagram;
    }

    protected static boolean checkDiagram(String fileName, String modelFileName, String[] diagramSuffixes, String[] modelSuffixes) {
        for (String modelSuffix : modelSuffixes) {
            String caseFilePrefix;
            if (!modelFileName.endsWith(modelSuffix) || !fileName.startsWith(caseFilePrefix = modelFileName.substring(0, modelFileName.length() - modelSuffix.length()))) continue;
            for (String diagramResourceSuffix : diagramSuffixes) {
                if (!fileName.endsWith(diagramResourceSuffix)) continue;
                return true;
            }
        }
        return false;
    }
}

