/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.deployment.jobexecutor;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.container.impl.spi.DeploymentOperation;
import org.camunda.bpm.container.impl.spi.DeploymentOperationStep;
import org.camunda.bpm.container.impl.spi.PlatformServiceContainer;
import org.camunda.bpm.container.impl.spi.ServiceTypes;

public class StopJobExecutorStep
extends DeploymentOperationStep {
    private static final Logger LOGGER = Logger.getLogger(StopJobExecutorStep.class.getName());

    @Override
    public String getName() {
        return "Stop managed job acquisitions";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        Set<String> jobExecutorServiceNames = serviceContainer.getServiceNames(ServiceTypes.JOB_EXECUTOR);
        for (String serviceName : jobExecutorServiceNames) {
            try {
                serviceContainer.stopService(serviceName);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Exception while stopping job executor service: " + e.getMessage(), e);
            }
        }
    }
}

