/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test;

import java.io.FileNotFoundException;
import java.util.Date;
import junit.framework.TestCase;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.test.ProcessEngineAssert;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class ProcessEngineTestCase
extends TestCase {
    protected String configurationResource = "camunda.cfg.xml";
    protected String configurationResourceCompat = "activiti.cfg.xml";
    protected String deploymentId = null;
    protected ProcessEngine processEngine;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    @Deprecated
    protected HistoryService historicDataService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    protected FormService formService;
    protected FilterService filterService;
    protected AuthorizationService authorizationService;
    protected CaseService caseService;

    public void assertProcessEnded(String processInstanceId) {
        ProcessEngineAssert.assertProcessEnded(this.processEngine, processInstanceId);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.processEngine == null) {
            this.initializeProcessEngine();
            this.initializeServices();
        }
        this.deploymentId = TestHelper.annotationDeploymentSetUp(this.processEngine, ((Object)((Object)this)).getClass(), this.getName());
    }

    protected void initializeProcessEngine() {
        try {
            this.processEngine = TestHelper.getProcessEngine(this.getConfigurationResource());
        }
        catch (RuntimeException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof FileNotFoundException) {
                this.processEngine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource(this.configurationResourceCompat).buildProcessEngine();
            }
            throw ex;
        }
    }

    protected void initializeServices() {
        this.repositoryService = this.processEngine.getRepositoryService();
        this.runtimeService = this.processEngine.getRuntimeService();
        this.taskService = this.processEngine.getTaskService();
        this.historicDataService = this.processEngine.getHistoryService();
        this.historyService = this.processEngine.getHistoryService();
        this.identityService = this.processEngine.getIdentityService();
        this.managementService = this.processEngine.getManagementService();
        this.formService = this.processEngine.getFormService();
        this.filterService = this.processEngine.getFilterService();
        this.authorizationService = this.processEngine.getAuthorizationService();
        this.caseService = this.processEngine.getCaseService();
    }

    protected void tearDown() throws Exception {
        TestHelper.annotationDeploymentTearDown(this.processEngine, this.deploymentId, ((Object)((Object)this)).getClass(), this.getName());
        ClockUtil.reset();
        super.tearDown();
    }

    public static void closeProcessEngines() {
        TestHelper.closeProcessEngines();
    }

    public void setCurrentTime(Date currentTime) {
        ClockUtil.setCurrentTime(currentTime);
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
    }
}

