/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable.serializer;

import java.util.Arrays;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.variable.serializer.AbstractObjectValueSerializer;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class DeserializedObject {
    protected AbstractObjectValueSerializer serializer;
    Object deserializedObject;
    byte[] originalBytes;
    VariableInstanceEntity variableInstanceEntity;

    public DeserializedObject(AbstractObjectValueSerializer serializer, Object deserializedObject, byte[] serializedBytes, VariableInstanceEntity variableInstanceEntity) {
        this.serializer = serializer;
        this.deserializedObject = deserializedObject;
        this.originalBytes = serializedBytes;
        this.variableInstanceEntity = variableInstanceEntity;
    }

    public void flush() {
        TypedValue cachedValue = this.variableInstanceEntity.getCachedValue();
        if (cachedValue != null && this.deserializedObject == cachedValue.getValue()) {
            try {
                byte[] bytes = this.serializer.serializeToByteArray(this.deserializedObject);
                if (!Arrays.equals(this.originalBytes, bytes)) {
                    this.variableInstanceEntity.getByteArrayValue().setBytes(bytes);
                }
            }
            catch (Exception e) {
                throw new ProcessEngineException("Exception while serializing object: " + e.getMessage(), e);
            }
        }
    }
}

