/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.core.variable.type;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.impl.core.variable.type.AbstractValueTypeImpl;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.SerializableValueType;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.SerializableValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.engine.variable.value.builder.ObjectValueBuilder;
import org.camunda.bpm.engine.variable.value.builder.SerializedObjectValueBuilder;

public class ObjectTypeImpl
extends AbstractValueTypeImpl
implements SerializableValueType {
    public static final String VALUE_INFO_OBJECT_TYPE_NAME = "objectTypeName";
    public static final String VALUE_INFO_SERIALIZATION_DATA_FORMAT = "serializationDataFormat";
    private static final long serialVersionUID = 1L;
    public static final String TYPE_NAME = "object";

    public ObjectTypeImpl() {
        super(TYPE_NAME);
    }

    @Override
    public boolean isPrimitiveValueType() {
        return false;
    }

    @Override
    public TypedValue createValue(Object value, Map<String, Object> valueInfo) {
        ObjectValueBuilder builder = Variables.objectValue(value);
        if (valueInfo != null) {
            this.applyValueInfo(builder, valueInfo);
        }
        return builder.create();
    }

    @Override
    public Map<String, Object> getValueInfo(TypedValue typedValue) {
        String objectTypeName;
        if (!(typedValue instanceof ObjectValue)) {
            throw new IllegalArgumentException("Value not of type Object.");
        }
        ObjectValue objectValue = (ObjectValue)typedValue;
        HashMap<String, Object> valueInfo = new HashMap<String, Object>();
        String serializationDataFormat = objectValue.getSerializationDataFormat();
        if (serializationDataFormat != null) {
            valueInfo.put(VALUE_INFO_SERIALIZATION_DATA_FORMAT, serializationDataFormat);
        }
        if ((objectTypeName = objectValue.getObjectTypeName()) != null) {
            valueInfo.put(VALUE_INFO_OBJECT_TYPE_NAME, objectTypeName);
        }
        return valueInfo;
    }

    @Override
    public SerializableValue createValueFromSerialized(String serializedValue, Map<String, Object> valueInfo) {
        SerializedObjectValueBuilder builder = Variables.serializedObjectValue(serializedValue);
        if (valueInfo != null) {
            this.applyValueInfo(builder, valueInfo);
        }
        return (SerializableValue)builder.create();
    }

    protected void applyValueInfo(ObjectValueBuilder builder, Map<String, Object> valueInfo) {
        String serializationDataFormat;
        String objectValueTypeName = (String)valueInfo.get(VALUE_INFO_OBJECT_TYPE_NAME);
        if (builder instanceof SerializedObjectValueBuilder) {
            ((SerializedObjectValueBuilder)builder).objectTypeName(objectValueTypeName);
        }
        if ((serializationDataFormat = (String)valueInfo.get(VALUE_INFO_SERIALIZATION_DATA_FORMAT)) != null) {
            builder.serializationDataFormat(serializationDataFormat);
        }
    }
}

