/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Date;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.AbstractSetJobDefinitionStateCmd;
import org.camunda.bpm.engine.impl.cmd.AbstractSetProcessInstanceStateCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.TimerChangeProcessDefinitionSuspensionStateJobHandler;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;

public abstract class AbstractSetProcessDefinitionStateCmd
implements Command<Void> {
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected ProcessDefinitionEntity processDefinitionEntity;
    protected boolean includeProcessInstances = false;
    protected Date executionDate;

    public AbstractSetProcessDefinitionStateCmd(ProcessDefinitionEntity processDefinitionEntity, boolean includeProcessInstances, Date executionDate) {
        this.processDefinitionEntity = processDefinitionEntity;
        this.processDefinitionId = processDefinitionEntity.getId();
        this.includeProcessInstances = includeProcessInstances;
        this.executionDate = executionDate;
    }

    public AbstractSetProcessDefinitionStateCmd(String processDefinitionId, String processDefinitionKey, boolean includeProcessInstances, Date executionDate) {
        this.processDefinitionId = processDefinitionId;
        this.processDefinitionKey = processDefinitionKey;
        this.includeProcessInstances = includeProcessInstances;
        this.executionDate = executionDate;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.processDefinitionId == null && this.processDefinitionKey == null) {
            throw new ProcessEngineException("Process definition id / key cannot be null");
        }
        if (this.executionDate == null) {
            this.updateSuspensionState(commandContext);
        } else {
            this.scheduleSuspensionStateUpdate(commandContext);
        }
        return null;
    }

    protected void scheduleSuspensionStateUpdate(CommandContext commandContext) {
        TimerEntity timer = new TimerEntity();
        timer.setDuedate(this.executionDate);
        timer.setJobHandlerType(this.getDelayedExecutionJobHandlerType());
        String jobConfiguration = null;
        if (this.processDefinitionId != null) {
            jobConfiguration = TimerChangeProcessDefinitionSuspensionStateJobHandler.createJobHandlerConfigurationByProcessDefinitionId(this.processDefinitionId, this.includeProcessInstances);
        } else if (this.processDefinitionKey != null) {
            jobConfiguration = TimerChangeProcessDefinitionSuspensionStateJobHandler.createJobHandlerConfigurationByProcessDefinitionKey(this.processDefinitionKey, this.includeProcessInstances);
        }
        timer.setJobHandlerConfiguration(jobConfiguration);
        commandContext.getJobManager().schedule(timer);
    }

    protected void updateSuspensionState(CommandContext commandContext) {
        ProcessDefinitionManager processDefinitionManager = commandContext.getProcessDefinitionManager();
        SuspensionState suspensionState = this.getProcessDefinitionSuspensionState();
        if (this.processDefinitionId != null) {
            processDefinitionManager.updateProcessDefinitionSuspensionStateById(this.processDefinitionId, suspensionState);
        } else if (this.processDefinitionKey != null) {
            processDefinitionManager.updateProcessDefinitionSuspensionStateByKey(this.processDefinitionKey, suspensionState);
        }
        this.getSetJobDefinitionStateCmd().execute(commandContext);
        if (this.includeProcessInstances) {
            this.getSetProcessInstanceStateCmd().execute(commandContext);
        }
    }

    protected abstract SuspensionState getProcessDefinitionSuspensionState();

    protected abstract String getDelayedExecutionJobHandlerType();

    protected abstract AbstractSetJobDefinitionStateCmd getSetJobDefinitionStateCmd();

    protected abstract AbstractSetProcessInstanceStateCmd getSetProcessInstanceStateCmd();
}

