/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.calendar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class DurationHelper {
    Date start;
    Date end;
    Duration period;
    boolean isRepeat;
    int times;
    DatatypeFactory datatypeFactory;

    public DurationHelper(String expressions) throws Exception {
        List<Object> expression = new ArrayList();
        if (expressions != null) {
            expression = Arrays.asList(expressions.split("/"));
        }
        this.datatypeFactory = DatatypeFactory.newInstance();
        if (expression.size() > 3 || expression.isEmpty()) {
            throw new ProcessEngineException("Cannot parse duration");
        }
        if (((String)expression.get(0)).startsWith("R")) {
            this.isRepeat = true;
            this.times = ((String)expression.get(0)).length() == 1 ? Integer.MAX_VALUE : Integer.parseInt(((String)expression.get(0)).substring(1));
            expression = expression.subList(1, expression.size());
        }
        if (this.isDuration((String)expression.get(0))) {
            this.period = this.parsePeriod((String)expression.get(0));
            this.end = expression.size() == 1 ? null : DateTimeUtil.parseDate((String)expression.get(1));
        } else {
            this.start = DateTimeUtil.parseDate((String)expression.get(0));
            if (this.isDuration((String)expression.get(1))) {
                this.period = this.parsePeriod((String)expression.get(1));
            } else {
                this.end = DateTimeUtil.parseDate((String)expression.get(1));
                this.period = this.datatypeFactory.newDuration(this.end.getTime() - this.start.getTime());
            }
        }
        if (this.start == null && this.end == null) {
            this.start = ClockUtil.getCurrentTime();
        }
    }

    public Date getDateAfter() {
        if (this.isRepeat) {
            return this.getDateAfterRepeat(ClockUtil.getCurrentTime());
        }
        if (this.end != null) {
            return this.end;
        }
        return this.add(this.start, this.period);
    }

    public int getTimes() {
        return this.times;
    }

    private Date getDateAfterRepeat(Date date) {
        if (this.start != null) {
            Date cur = this.start;
            for (int i = 0; i < this.times && !cur.after(date); ++i) {
                cur = this.add(cur, this.period);
            }
            return cur.before(date) ? null : cur;
        }
        Date cur = this.add(this.end, this.period.negate());
        Date next = this.end;
        for (int i = 0; i < this.times && cur.after(date); ++i) {
            next = cur;
            cur = this.add(cur, this.period.negate());
        }
        return next.before(date) ? null : next;
    }

    private Date add(Date date, Duration duration) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        duration.addTo(calendar);
        return calendar.getTime();
    }

    private Duration parsePeriod(String period) {
        return this.datatypeFactory.newDuration(period);
    }

    private boolean isDuration(String time) {
        return time.startsWith("P");
    }
}

