/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.application;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.ProcessApplicationRegistration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.application.DefaultProcessApplicationRegistration;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentFailListener;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class ProcessApplicationManager {
    private Logger LOGGER = Logger.getLogger(ProcessApplicationManager.class.getName());
    protected Map<String, DefaultProcessApplicationRegistration> registrationsByDeploymentId = new HashMap<String, DefaultProcessApplicationRegistration>();

    public ProcessApplicationReference getProcessApplicationForDeployment(String deploymentId) {
        DefaultProcessApplicationRegistration registration = this.registrationsByDeploymentId.get(deploymentId);
        if (registration != null) {
            return registration.getReference();
        }
        return null;
    }

    public synchronized ProcessApplicationRegistration registerProcessApplicationForDeployments(Set<String> deploymentsToRegister, ProcessApplicationReference reference) {
        DefaultProcessApplicationRegistration registration = this.createProcessApplicationRegistration(deploymentsToRegister, reference);
        this.createJobExecutorRegistrations(deploymentsToRegister);
        this.logRegistration(deploymentsToRegister, reference);
        return registration;
    }

    public synchronized void unregisterProcessApplicationForDeployments(Set<String> deploymentIds, boolean removeProcessesFromCache) {
        this.removeJobExecutorRegistrations(deploymentIds);
        this.removeProcessApplicationRegistration(deploymentIds, removeProcessesFromCache);
    }

    protected DefaultProcessApplicationRegistration createProcessApplicationRegistration(Set<String> deploymentsToRegister, ProcessApplicationReference reference) {
        String processEngineName = Context.getProcessEngineConfiguration().getProcessEngineName();
        DefaultProcessApplicationRegistration registration = new DefaultProcessApplicationRegistration(reference, deploymentsToRegister, processEngineName);
        for (String deploymentId : deploymentsToRegister) {
            this.registrationsByDeploymentId.put(deploymentId, registration);
        }
        return registration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeProcessApplicationRegistration(Set<String> deploymentIds, boolean removeProcessesFromCache) {
        for (String deploymentId : deploymentIds) {
            try {
                if (!removeProcessesFromCache) continue;
                Context.getProcessEngineConfiguration().getDeploymentCache().removeDeployment(deploymentId);
            }
            catch (Throwable t) {
                this.LOGGER.log(Level.WARNING, "unregistering process application for deployment but could not remove process definitions from deployment cache. ", t);
            }
            finally {
                if (deploymentId == null) continue;
                this.registrationsByDeploymentId.remove(deploymentId);
            }
        }
    }

    protected void createJobExecutorRegistrations(Set<String> deploymentIds) {
        try {
            Context.getCommandContext().getTransactionContext().addTransactionListener(TransactionState.ROLLED_BACK, new DeploymentFailListener(deploymentIds));
            Set<String> registeredDeployments = Context.getProcessEngineConfiguration().getRegisteredDeployments();
            registeredDeployments.addAll(deploymentIds);
        }
        catch (Exception e) {
            throw new ProcessEngineException("Could not register deployments with Job Executor.", e);
        }
    }

    protected void removeJobExecutorRegistrations(Set<String> deploymentIds) {
        try {
            Set<String> registeredDeployments = Context.getProcessEngineConfiguration().getRegisteredDeployments();
            registeredDeployments.removeAll(deploymentIds);
        }
        catch (Exception e) {
            this.LOGGER.log(Level.WARNING, "Could not unregister deployments with Job Executor.", e);
        }
    }

    protected void logRegistration(Set<String> deploymentIds, ProcessApplicationReference reference) {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("ProcessApplication '");
            builder.append(reference.getName());
            builder.append("' registered for DB deployments ");
            builder.append(deploymentIds);
            builder.append(". ");
            ArrayList<ProcessDefinition> processDefinitions = new ArrayList<ProcessDefinition>();
            ArrayList<CaseDefinition> caseDefinitions = new ArrayList<CaseDefinition>();
            CommandContext commandContext = Context.getCommandContext();
            for (String deploymentId : deploymentIds) {
                DeploymentEntity deployment = commandContext.getDbEntityManager().selectById(DeploymentEntity.class, deploymentId);
                if (deployment == null) continue;
                processDefinitions.addAll(this.getDeployedProcessDefinitionArtifacts(deployment));
                caseDefinitions.addAll(this.getDeployedCaseDefinitionArtifacts(deployment));
            }
            this.logProcessDefinitionRegistrations(builder, processDefinitions);
            this.logCaseDefinitionRegistrations(builder, caseDefinitions);
            this.LOGGER.info(builder.toString());
        }
        catch (Throwable e) {
            this.LOGGER.log(Level.WARNING, "Exception while logging registration summary", e);
        }
    }

    protected List<ProcessDefinition> getDeployedProcessDefinitionArtifacts(DeploymentEntity deployment) {
        CommandContext commandContext = Context.getCommandContext();
        List<ProcessDefinitionEntity> entities = deployment.getDeployedArtifacts(ProcessDefinitionEntity.class);
        if (entities == null) {
            String deploymentId = deployment.getId();
            return new ProcessDefinitionQueryImpl(commandContext).deploymentId(deploymentId).list();
        }
        return new ArrayList<ProcessDefinition>(entities);
    }

    protected List<CaseDefinition> getDeployedCaseDefinitionArtifacts(DeploymentEntity deployment) {
        CommandContext commandContext = Context.getCommandContext();
        List<CaseDefinitionEntity> entities = deployment.getDeployedArtifacts(CaseDefinitionEntity.class);
        if (entities == null) {
            String deploymentId = deployment.getId();
            return new CaseDefinitionQueryImpl(commandContext).deploymentId(deploymentId).list();
        }
        return new ArrayList<CaseDefinition>(entities);
    }

    protected void logProcessDefinitionRegistrations(StringBuilder builder, List<ProcessDefinition> processDefinitions) {
        if (processDefinitions.isEmpty()) {
            builder.append("Deployment does not provide any process definitions.");
        } else {
            builder.append("Will execute process definitions ");
            builder.append("\n");
            for (ProcessDefinition processDefinition : processDefinitions) {
                builder.append("\n");
                builder.append("        ");
                builder.append(processDefinition.getKey());
                builder.append("[version: ");
                builder.append(processDefinition.getVersion());
                builder.append(", id: ");
                builder.append(processDefinition.getId());
                builder.append("]");
            }
            builder.append("\n");
        }
    }

    protected void logCaseDefinitionRegistrations(StringBuilder builder, List<CaseDefinition> caseDefinitions) {
        if (caseDefinitions.isEmpty()) {
            builder.append("Deployment does not provide any case definitions.");
        } else {
            builder.append("\n");
            builder.append("Will execute case definitions ");
            builder.append("\n");
            for (CaseDefinition caseDefinition : caseDefinitions) {
                builder.append("\n");
                builder.append("        ");
                builder.append(caseDefinition.getKey());
                builder.append("[version: ");
                builder.append(caseDefinition.getVersion());
                builder.append(", id: ");
                builder.append(caseDefinition.getId());
                builder.append("]");
            }
            builder.append("\n");
        }
    }

    public String getRegistrationSummary() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, DefaultProcessApplicationRegistration> entry : this.registrationsByDeploymentId.entrySet()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(entry.getKey());
            builder.append("->");
            builder.append(entry.getValue().getReference().getName());
        }
        return builder.toString();
    }
}

