/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.QueryOperator;
import org.camunda.bpm.engine.impl.QueryVariableValue;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.variable.serializer.VariableSerializers;
import org.camunda.bpm.engine.query.Query;

public abstract class AbstractVariableQueryImpl<T extends Query<?, ?>, U>
extends AbstractQuery<T, U> {
    private static final long serialVersionUID = 1L;
    protected List<QueryVariableValue> queryVariableValues = new ArrayList<QueryVariableValue>();

    public AbstractVariableQueryImpl() {
    }

    public AbstractVariableQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public AbstractVariableQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public abstract long executeCount(CommandContext var1);

    @Override
    public abstract List<U> executeList(CommandContext var1, Page var2);

    public T variableValueEquals(String name, Object value) {
        this.addVariable(name, value, QueryOperator.EQUALS, true);
        return (T)this;
    }

    public T variableValueNotEquals(String name, Object value) {
        this.addVariable(name, value, QueryOperator.NOT_EQUALS, true);
        return (T)this;
    }

    public T variableValueGreaterThan(String name, Object value) {
        this.addVariable(name, value, QueryOperator.GREATER_THAN, true);
        return (T)this;
    }

    public T variableValueGreaterThanOrEqual(String name, Object value) {
        this.addVariable(name, value, QueryOperator.GREATER_THAN_OR_EQUAL, true);
        return (T)this;
    }

    public T variableValueLessThan(String name, Object value) {
        this.addVariable(name, value, QueryOperator.LESS_THAN, true);
        return (T)this;
    }

    public T variableValueLessThanOrEqual(String name, Object value) {
        this.addVariable(name, value, QueryOperator.LESS_THAN_OR_EQUAL, true);
        return (T)this;
    }

    public T variableValueLike(String name, String value) {
        this.addVariable(name, value, QueryOperator.LIKE, true);
        return (T)this;
    }

    protected void addVariable(String name, Object value, QueryOperator operator, boolean processInstanceScope) {
        EnsureUtil.ensureNotNull(NotValidException.class, "name", (Object)name);
        if (value == null || this.isBoolean(value)) {
            switch (operator) {
                case GREATER_THAN: {
                    throw new NotValidException("Booleans and null cannot be used in 'greater than' condition");
                }
                case LESS_THAN: {
                    throw new NotValidException("Booleans and null cannot be used in 'less than' condition");
                }
                case GREATER_THAN_OR_EQUAL: {
                    throw new NotValidException("Booleans and null cannot be used in 'greater than or equal' condition");
                }
                case LESS_THAN_OR_EQUAL: {
                    throw new NotValidException("Booleans and null cannot be used in 'less than or equal' condition");
                }
                case LIKE: {
                    throw new NotValidException("Booleans and null cannot be used in 'like' condition");
                }
            }
        }
        this.queryVariableValues.add(new QueryVariableValue(name, value, operator, processInstanceScope));
    }

    private boolean isBoolean(Object value) {
        if (value == null) {
            return false;
        }
        return Boolean.class.isAssignableFrom(value.getClass()) || Boolean.TYPE.isAssignableFrom(value.getClass());
    }

    protected void ensureVariablesInitialized() {
        if (!this.queryVariableValues.isEmpty()) {
            VariableSerializers variableSerializers = Context.getProcessEngineConfiguration().getVariableSerializers();
            for (QueryVariableValue queryVariableValue : this.queryVariableValues) {
                queryVariableValue.initialize(variableSerializers);
            }
        }
    }

    public List<QueryVariableValue> getQueryVariableValues() {
        return this.queryVariableValues;
    }
}

