/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.Direction;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.query.QueryProperty;
import org.joda.time.DateTime;

public abstract class AbstractQuery<T extends Query<?, ?>, U>
extends ListQueryParameterObject
implements Command<Object>,
Query<T, U>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SORTORDER_ASC = "asc";
    public static final String SORTORDER_DESC = "desc";
    protected transient CommandExecutor commandExecutor;
    protected transient CommandContext commandContext;
    protected ResultType resultType;
    protected QueryProperty orderProperty;
    protected Map<String, String> expressions = new HashMap<String, String>();

    protected AbstractQuery() {
    }

    protected AbstractQuery(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public AbstractQuery(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    public AbstractQuery<T, U> setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        return this;
    }

    public T orderBy(QueryProperty property) {
        this.orderProperty = property;
        return (T)this;
    }

    @Override
    public T asc() {
        return this.direction(Direction.ASCENDING);
    }

    @Override
    public T desc() {
        return this.direction(Direction.DESCENDING);
    }

    public T direction(Direction direction) {
        EnsureUtil.ensureNotNull(NotValidException.class, "You should call any of the orderBy methods first before specifying a direction", "orderProperty", (Object)this.orderProperty);
        this.addOrder(this.orderProperty.getName(), direction.getName());
        this.orderProperty = null;
        return (T)this;
    }

    protected void checkQueryOk() {
        if (this.orderProperty != null) {
            throw new NotValidException("Invalid query: call asc() or desc() after using orderByXX()");
        }
    }

    @Override
    public U singleResult() {
        this.resultType = ResultType.SINGLE_RESULT;
        if (this.commandExecutor != null) {
            return (U)this.commandExecutor.execute(this);
        }
        return this.executeSingleResult(Context.getCommandContext());
    }

    @Override
    public List<U> list() {
        this.resultType = ResultType.LIST;
        if (this.commandExecutor != null) {
            return (List)this.commandExecutor.execute(this);
        }
        return this.evaluateExpressionsAndExecuteList(Context.getCommandContext(), null);
    }

    @Override
    public List<U> listPage(int firstResult, int maxResults) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        this.resultType = ResultType.LIST_PAGE;
        if (this.commandExecutor != null) {
            return (List)this.commandExecutor.execute(this);
        }
        return this.evaluateExpressionsAndExecuteList(Context.getCommandContext(), new Page(firstResult, maxResults));
    }

    @Override
    public long count() {
        this.resultType = ResultType.COUNT;
        if (this.commandExecutor != null) {
            return (Long)this.commandExecutor.execute(this);
        }
        return this.evaluateExpressionsAndExecuteCount(Context.getCommandContext());
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.resultType == ResultType.LIST) {
            return this.evaluateExpressionsAndExecuteList(commandContext, null);
        }
        if (this.resultType == ResultType.SINGLE_RESULT) {
            return this.executeSingleResult(commandContext);
        }
        if (this.resultType == ResultType.LIST_PAGE) {
            return this.evaluateExpressionsAndExecuteList(commandContext, null);
        }
        return this.evaluateExpressionsAndExecuteCount(commandContext);
    }

    public long evaluateExpressionsAndExecuteCount(CommandContext commandContext) {
        this.evaluateExpressions();
        return this.executeCount(commandContext);
    }

    public abstract long executeCount(CommandContext var1);

    public List<U> evaluateExpressionsAndExecuteList(CommandContext commandContext, Page page) {
        this.evaluateExpressions();
        return this.executeList(commandContext, page);
    }

    public abstract List<U> executeList(CommandContext var1, Page var2);

    public U executeSingleResult(CommandContext commandContext) {
        List<U> results = this.evaluateExpressionsAndExecuteList(commandContext, null);
        if (results.size() == 1) {
            return results.get(0);
        }
        if (results.size() > 1) {
            throw new ProcessEngineException("Query return " + results.size() + " results instead of max 1");
        }
        return null;
    }

    protected void addOrder(String column, String sortOrder) {
        this.orderBy = this.orderBy == null ? "" : this.orderBy + ", ";
        this.orderBy = this.orderBy + column + " " + sortOrder;
    }

    @Override
    public String getOrderBy() {
        if (this.orderBy == null) {
            return super.getOrderBy();
        }
        return this.orderBy;
    }

    public QueryProperty getOrderProperty() {
        return this.orderProperty;
    }

    public Map<String, String> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(Map<String, String> expressions) {
        this.expressions = expressions;
    }

    public void addExpression(String key, String expression) {
        this.expressions.put(key, expression);
    }

    protected void evaluateExpressions() {
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(this.expressions.entrySet());
        for (Map.Entry<String, String> entry : entries) {
            Object value;
            String methodName = entry.getKey();
            String expression = entry.getValue();
            try {
                value = Context.getProcessEngineConfiguration().getExpressionManager().createExpression(expression).getValue(null);
            }
            catch (ProcessEngineException e) {
                throw new ProcessEngineException("Unable to resolve expression '" + expression + "' for method '" + methodName + "' on class '" + this.getClass().getCanonicalName() + "'", e);
            }
            if (value instanceof DateTime) {
                value = ((DateTime)value).toDate();
            }
            try {
                Method method = this.getMethod(methodName);
                method.invoke((Object)this, value);
            }
            catch (InvocationTargetException e) {
                throw new ProcessEngineException("Unable to invoke method '" + methodName + "' on class '" + this.getClass().getCanonicalName() + "'", e);
            }
            catch (IllegalAccessException e) {
                throw new ProcessEngineException("Unable to access method '" + methodName + "' on class '" + this.getClass().getCanonicalName() + "'", e);
            }
        }
    }

    protected Method getMethod(String methodName) {
        for (Method method : this.getClass().getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        throw new ProcessEngineException("Unable to find method '" + methodName + "' on class '" + this.getClass().getCanonicalName() + "'");
    }

    public T extend(T extendingQuery) {
        throw new ProcessEngineException("Extending of query type '" + extendingQuery.getClass().getCanonicalName() + "' currently not supported");
    }

    protected void mergeOrdering(AbstractQuery<?, ?> extendedQuery, AbstractQuery<?, ?> extendingQuery) {
        extendedQuery.orderBy = this.orderBy;
        if (extendingQuery.orderBy != null) {
            extendedQuery.orderBy = extendedQuery.orderBy == null ? extendingQuery.orderBy : extendedQuery.orderBy + ", " + extendingQuery.orderBy;
        }
    }

    protected void mergeExpressions(AbstractQuery<?, ?> extendedQuery, AbstractQuery<?, ?> extendingQuery) {
        HashMap<String, String> mergedExpressions = new HashMap<String, String>(extendingQuery.getExpressions());
        for (Map.Entry<String, String> entry : this.getExpressions().entrySet()) {
            if (mergedExpressions.containsKey(entry.getKey())) continue;
            mergedExpressions.put(entry.getKey(), entry.getValue());
        }
        extendedQuery.setExpressions(mergedExpressions);
    }

    private static enum ResultType {
        LIST,
        LIST_PAGE,
        SINGLE_RESULT,
        COUNT;

    }
}

