/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableInstance;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableScope;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableStore;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.variable.VariableType;
import org.camunda.bpm.engine.impl.variable.VariableTypes;

public abstract class AbstractVariableStore
implements Serializable,
CoreVariableStore {
    private static final long serialVersionUID = 1L;
    protected Map<String, VariableInstanceEntity> variableInstances = null;

    protected abstract List<VariableInstanceEntity> loadVariableInstances();

    protected abstract void initializeVariableInstanceBackPointer(VariableInstanceEntity var1);

    public void ensureVariableInstancesInitialized() {
        if (this.variableInstances == null) {
            this.variableInstances = new HashMap<String, VariableInstanceEntity>();
            CommandContext commandContext = Context.getCommandContext();
            EnsureUtil.ensureNotNull("lazy loading outside command context", "commandContext", (Object)commandContext);
            List<VariableInstanceEntity> variableInstancesList = this.loadVariableInstances();
            for (VariableInstanceEntity variableInstance : variableInstancesList) {
                this.variableInstances.put(variableInstance.getName(), variableInstance);
            }
        }
    }

    @Override
    public Map<String, CoreVariableInstance> getVariableInstances() {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances;
    }

    public void setVariableInstances(Map<String, VariableInstanceEntity> variableInstances) {
        this.variableInstances = variableInstances;
    }

    @Override
    public Collection<CoreVariableInstance> getVariableInstancesValues() {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances.values();
    }

    @Override
    public CoreVariableInstance getVariableInstance(String variableName) {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances.get(variableName);
    }

    @Override
    public Set<String> getVariableNames() {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances.keySet();
    }

    @Override
    public boolean isEmpty() {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances.isEmpty();
    }

    @Override
    public boolean containsVariableInstance(String variableName) {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances.containsKey(variableName);
    }

    @Override
    public CoreVariableInstance removeVariableInstance(String variableName, CoreVariableScope sourceActivityExecution) {
        this.ensureVariableInstancesInitialized();
        VariableInstanceEntity variable = this.variableInstances.remove(variableName);
        if (variable != null) {
            variable.delete();
            variable.setValue(null);
            if (this.isAutoFireHistoryEvents()) {
                this.fireHistoricVariableInstanceDelete(variable, sourceActivityExecution);
            }
        }
        return variable;
    }

    @Override
    public void setVariableInstanceValue(CoreVariableInstance variableInstance, Object value, CoreVariableScope sourceActivityExecution) {
        VariableInstanceEntity variableInstanceEntity = (VariableInstanceEntity)variableInstance;
        variableInstanceEntity.setValue(value);
        if (this.isAutoFireHistoryEvents()) {
            this.fireHistoricVariableInstanceUpdate(variableInstanceEntity, sourceActivityExecution);
        }
    }

    @Override
    public VariableInstanceEntity createVariableInstance(String variableName, Object value, CoreVariableScope sourceActivityExecution) {
        VariableType type = this.getNewVariableType(value);
        VariableInstanceEntity variableInstance = VariableInstanceEntity.createAndInsert(variableName, type, value);
        this.initializeVariableInstanceBackPointer(variableInstance);
        this.variableInstances.put(variableName, variableInstance);
        if (this.isAutoFireHistoryEvents()) {
            this.fireHistoricVariableInstanceCreate(variableInstance, sourceActivityExecution);
        }
        return variableInstance;
    }

    protected boolean isAutoFireHistoryEvents() {
        return true;
    }

    protected VariableType getNewVariableType(Object newValue) {
        VariableTypes variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
        return variableTypes.findVariableType(newValue);
    }

    @Override
    public void clearForNewValue(CoreVariableInstance variableInstance, Object newValue) {
        VariableInstanceEntity variableInstanceEntity = (VariableInstanceEntity)variableInstance;
        VariableType oldType = variableInstanceEntity.getType();
        VariableType newType = this.getNewVariableType(newValue);
        if (oldType.getTypeName().equals(newType.getTypeName())) {
            return;
        }
        if (variableInstanceEntity.getByteArrayValueId() == null) {
            variableInstanceEntity.setValue(null);
        } else {
            variableInstanceEntity.getByteArrayValue();
            Context.getCommandContext().getByteArrayManager().deleteByteArrayById(variableInstanceEntity.getByteArrayValueId());
            variableInstanceEntity.setByteArrayValueId(null);
        }
        variableInstanceEntity.setType(newType);
    }

    public void removeVariablesWithoutFiringEvents() {
        this.ensureVariableInstancesInitialized();
        for (VariableInstanceEntity variable : this.variableInstances.values()) {
            variable.delete();
        }
        this.variableInstances.clear();
    }

    public void fireHistoricVariableInstanceDelete(VariableInstanceEntity variableInstance, CoreVariableScope sourceActivityExecution) {
        int historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        if (historyLevel >= 2) {
            ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
            HistoryEventHandler eventHandler = processEngineConfiguration.getHistoryEventHandler();
            HistoryEventProducer eventProducer = processEngineConfiguration.getHistoryEventProducer();
            HistoryEvent evt = eventProducer.createHistoricVariableDeleteEvt(variableInstance, sourceActivityExecution);
            eventHandler.handleEvent(evt);
        }
    }

    public void fireHistoricVariableInstanceCreate(VariableInstanceEntity variableInstance, CoreVariableScope sourceActivityExecution) {
        int historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        if (historyLevel >= 2) {
            ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
            HistoryEventHandler eventHandler = processEngineConfiguration.getHistoryEventHandler();
            HistoryEventProducer eventProducer = processEngineConfiguration.getHistoryEventProducer();
            HistoryEvent evt = eventProducer.createHistoricVariableCreateEvt(variableInstance, sourceActivityExecution);
            eventHandler.handleEvent(evt);
        }
    }

    public void fireHistoricVariableInstanceUpdate(VariableInstanceEntity variableInstance, CoreVariableScope sourceActivityExecution) {
        int historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        if (historyLevel >= 2) {
            ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
            HistoryEventHandler eventHandler = processEngineConfiguration.getHistoryEventHandler();
            HistoryEventProducer eventProducer = processEngineConfiguration.getHistoryEventProducer();
            HistoryEvent evt = eventProducer.createHistoricVariableUpdateEvt(variableInstance, sourceActivityExecution);
            eventHandler.handleEvent(evt);
        }
    }
}

