/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.spin;

import java.io.UnsupportedEncodingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.variable.ValueFields;
import org.camunda.bpm.engine.impl.variable.VariableType;
import org.camunda.spin.Spin;
import org.camunda.spin.SpinFactory;
import org.camunda.spin.SpinRuntimeException;
import org.camunda.spin.spi.DataFormat;

public class SpinSerializationType
implements VariableType {
    public static final String TYPE_NAME = "SpinSerialization";
    protected DataFormat<?> dataFormat;

    public SpinSerializationType(DataFormat<?> dataFormat) {
        this.dataFormat = dataFormat;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getTypeNameForValue(Object value) {
        return "Object";
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public boolean isAbleToStore(Object value) {
        return true;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        try {
            Spin spin = SpinFactory.getInstance().createSpinFromObject(value, this.dataFormat);
            String serializedVariable = spin.toString();
            if (serializedVariable.getBytes().length <= 4000) {
                valueFields.setTextValue(spin.toString());
            } else {
                valueFields.setByteArrayValue(serializedVariable.getBytes());
            }
            valueFields.setDataFormatId(this.dataFormat.getName());
            valueFields.setTextValue2(this.dataFormat.getCanonicalTypeName(value));
        }
        catch (SpinRuntimeException e) {
            throw new ProcessEngineException("Cannot serialize object of type " + value.getClass() + ": " + value, e);
        }
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        try {
            String variableValue = valueFields.getTextValue();
            if (variableValue == null) {
                ByteArrayEntity byteEntity = valueFields.getByteArrayValue();
                if (byteEntity == null) {
                    return null;
                }
                variableValue = new String(valueFields.getByteArrayValue().getBytes());
            }
            Spin spinNode = SpinFactory.getInstance().createSpinFromString(variableValue, this.dataFormat);
            Object value = spinNode.mapTo(valueFields.getTextValue2());
            return value;
        }
        catch (SpinRuntimeException e) {
            throw new ProcessEngineException("Cannot deserialize variable '" + valueFields.getName() + "' of format '" + valueFields.getDataFormatId() + "' with configuration '" + valueFields.getTextValue2() + "'");
        }
    }

    @Override
    public Object getRawValue(ValueFields valueFields) {
        String value = null;
        if (valueFields.getTextValue() != null) {
            value = valueFields.getTextValue();
        } else if (valueFields.getByteArrayValue() != null) {
            try {
                ByteArrayEntity byteArray = valueFields.getByteArrayValue();
                value = new String(byteArray.getBytes(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ProcessEngineException("UTF-8 is not a supported encoding");
            }
        }
        return value;
    }

    public DataFormat<?> getDataFormat() {
        return this.dataFormat;
    }
}

