/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.scripting.engine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.scripting.engine.ScriptBindingsFactory;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class ScriptingEngines {
    private static Logger LOG = Logger.getLogger(ScriptingEngines.class.getName());
    public static final String DEFAULT_SCRIPTING_LANGUAGE = "juel";
    public static final String GROOVY_SCRIPTING_LANGUAGE = "groovy";
    private final ScriptEngineManager scriptEngineManager;
    protected ScriptBindingsFactory scriptBindingsFactory;
    protected Map<String, ScriptEngine> cachedEngines = new HashMap<String, ScriptEngine>();
    protected boolean enableScriptEngineCaching = true;

    public ScriptingEngines(ScriptBindingsFactory scriptBindingsFactory) {
        this(new ScriptEngineManager());
        this.scriptBindingsFactory = scriptBindingsFactory;
    }

    public ScriptingEngines(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    public void setEnableScriptEngineCaching(boolean cacheScriptEngines) {
        this.enableScriptEngineCaching = cacheScriptEngines;
    }

    public boolean isEnableScriptEngineCaching() {
        return this.enableScriptEngineCaching;
    }

    public ScriptingEngines addScriptEngineFactory(ScriptEngineFactory scriptEngineFactory) {
        this.scriptEngineManager.registerEngineName(scriptEngineFactory.getEngineName(), scriptEngineFactory);
        return this;
    }

    public void setScriptEngineFactories(List<ScriptEngineFactory> scriptEngineFactories) {
        if (scriptEngineFactories != null) {
            for (ScriptEngineFactory scriptEngineFactory : scriptEngineFactories) {
                this.scriptEngineManager.registerEngineName(scriptEngineFactory.getEngineName(), scriptEngineFactory);
            }
        }
    }

    public CompiledScript compile(String src, String language) {
        ScriptEngine scriptEngine = this.getScriptEngineForLanguage(language);
        if (scriptEngine instanceof Compilable && !scriptEngine.getFactory().getLanguageName().equalsIgnoreCase("ecmascript")) {
            Compilable compilingEngine = (Compilable)((Object)scriptEngine);
            try {
                CompiledScript compiledScript = compilingEngine.compile(src);
                LOG.log(Level.FINE, "Compiled script using {0} script engine ", language);
                return compiledScript;
            }
            catch (ScriptException e) {
                throw new ProcessEngineException("problem while compiling script: " + e.getMessage(), e);
            }
        }
        return null;
    }

    public ScriptEngine getScriptEngineForLanguage(String language) {
        if (language != null) {
            language = language.toLowerCase();
        }
        ScriptEngine scriptEngine = null;
        scriptEngine = this.enableScriptEngineCaching ? this.getCachedScriptEngine(language) : this.scriptEngineManager.getEngineByName(language);
        EnsureUtil.ensureNotNull("Can't find scripting engine for '" + language + "'", "scriptEngine", (Object)scriptEngine);
        return scriptEngine;
    }

    public Set<String> getAllSupportedLanguages() {
        HashSet<String> languages = new HashSet<String>();
        List<ScriptEngineFactory> engineFactories = this.scriptEngineManager.getEngineFactories();
        for (ScriptEngineFactory scriptEngineFactory : engineFactories) {
            languages.add(scriptEngineFactory.getLanguageName());
        }
        return languages;
    }

    protected ScriptEngine getCachedScriptEngine(String language) {
        ScriptEngine scriptEngine = this.cachedEngines.get(language);
        if (scriptEngine == null && (scriptEngine = this.scriptEngineManager.getEngineByName(language)) != null) {
            if (GROOVY_SCRIPTING_LANGUAGE.equals(language)) {
                this.configureGroovyScriptEngine(scriptEngine);
            }
            if (this.isCachable(scriptEngine)) {
                this.cachedEngines.put(language, scriptEngine);
            }
        }
        return scriptEngine;
    }

    protected boolean isCachable(ScriptEngine scriptEngine) {
        Object threadingParameter = scriptEngine.getFactory().getParameter("THREADING");
        return threadingParameter != null;
    }

    protected void configureGroovyScriptEngine(ScriptEngine scriptEngine) {
        scriptEngine.getContext().setAttribute("#jsr223.groovy.engine.keep.globals", "weak", 100);
    }

    public Bindings createBindings(ScriptEngine scriptEngine, VariableScope variableScope) {
        return this.scriptBindingsFactory.createBindings(variableScope, scriptEngine.createBindings());
    }

    public ScriptBindingsFactory getScriptBindingsFactory() {
        return this.scriptBindingsFactory;
    }

    public void setScriptBindingsFactory(ScriptBindingsFactory scriptBindingsFactory) {
        this.scriptBindingsFactory = scriptBindingsFactory;
    }
}

