/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.scripting;

import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.impl.Condition;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.scripting.ExecutableScript;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class ScriptCondition
implements Condition {
    protected final ExecutableScript script;

    public ScriptCondition(ExecutableScript script) {
        this.script = script;
    }

    @Override
    public boolean evaluate(DelegateExecution execution) {
        Boolean result = (Boolean)Context.getProcessEngineConfiguration().getScriptingEnvironment().execute(this.script, execution);
        EnsureUtil.ensureNotNull("condition script returns null", "result", (Object)result);
        EnsureUtil.ensureInstanceOf("condition script returns non-Boolean", "result", result, Boolean.class);
        return result;
    }

    public ExecutableScript getScript() {
        return this.script;
    }
}

