/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableScope;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmException;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.ActivityInstanceState;
import org.camunda.bpm.engine.impl.pvm.runtime.ExecutionStartContext;
import org.camunda.bpm.engine.impl.pvm.runtime.OutgoingExecution;
import org.camunda.bpm.engine.impl.pvm.runtime.ProcessInstanceStartContext;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.FoxAtomicOperationDeleteCascadeFireActivityEnd;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;

public abstract class PvmExecutionImpl
extends CoreExecution
implements ActivityExecution,
PvmProcessInstance {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(PvmExecutionImpl.class.getName());
    protected transient ProcessDefinitionImpl processDefinition;
    protected transient ExecutionStartContext startContext;
    protected transient ProcessInstanceStartContext processInstanceStartContext;
    protected transient ActivityImpl activity;
    protected transient ActivityImpl nextActivity;
    protected transient TransitionImpl transition = null;
    protected transient TransitionImpl transitionBeingTaken = null;
    protected String activityInstanceId;
    protected String caseInstanceId;
    protected boolean deleteRoot;
    protected String deleteReason;
    protected boolean isActive = true;
    protected boolean isScope = true;
    protected boolean isConcurrent = false;
    protected boolean isEnded = false;
    protected boolean isEventScope = false;
    protected int activityInstanceState = ActivityInstanceState.DEFAULT.getStateCode();

    public PvmExecutionImpl() {
    }

    public PvmExecutionImpl(ActivityImpl initialActivity) {
        this.processInstanceStartContext = new ProcessInstanceStartContext(initialActivity);
    }

    @Override
    public PvmExecutionImpl createExecution() {
        return this.createExecution(false);
    }

    @Override
    public abstract PvmExecutionImpl createExecution(boolean var1);

    @Override
    public PvmExecutionImpl createSubProcessInstance(PvmProcessDefinition processDefinition) {
        return this.createSubProcessInstance(processDefinition, null);
    }

    @Override
    public abstract PvmExecutionImpl createSubProcessInstance(PvmProcessDefinition var1, String var2);

    public abstract void initialize();

    @Override
    public void start() {
        this.start(null, null);
    }

    @Override
    public void start(Map<String, Object> variables) {
        this.start(null, variables);
    }

    @Override
    public void start(String businessKey) {
        this.start(businessKey, null);
    }

    @Override
    public void start(String businessKey, Map<String, Object> variables) {
        if (variables != null) {
            this.setVariables(variables);
        }
        if (businessKey != null) {
            this.setBusinessKey(businessKey);
        }
        this.performOperation(PvmAtomicOperation.PROCESS_START);
    }

    public void destroy() {
        log.fine("destroying " + this);
        this.setScope(false);
    }

    protected void removeEventScopes() {
        ArrayList<? extends PvmExecutionImpl> childExecutions = new ArrayList<PvmExecutionImpl>(this.getExecutions());
        for (PvmExecutionImpl pvmExecutionImpl : childExecutions) {
            if (!pvmExecutionImpl.isEventScope()) continue;
            log.fine("removing eventScope " + pvmExecutionImpl);
            pvmExecutionImpl.destroy();
            pvmExecutionImpl.remove();
        }
    }

    @Override
    public void cancelScope(String reason) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("performing cancel scope behavior for execution " + this);
        }
        if (this.getSubProcessInstance() != null) {
            this.getSubProcessInstance().deleteCascade(reason);
        }
        ArrayList<? extends PvmExecutionImpl> executions = new ArrayList<PvmExecutionImpl>(this.getExecutions());
        for (PvmExecutionImpl pvmExecutionImpl : executions) {
            if (pvmExecutionImpl.getSubProcessInstance() != null) {
                pvmExecutionImpl.getSubProcessInstance().deleteCascade(reason);
            }
            pvmExecutionImpl.deleteCascade(reason);
        }
        this.setCanceled(true);
        ActivityImpl activity = this.getActivity();
        if (this.isActive && activity != null) {
            this.performOperation(PvmAtomicOperation.FIRE_ACTIVITY_END);
        }
        this.activityInstanceState = ActivityInstanceState.DEFAULT.getStateCode();
    }

    @Override
    public void end(boolean completeScope) {
        this.setCompleteScope(completeScope);
        this.isActive = false;
        this.isEnded = true;
        this.performOperation(PvmAtomicOperation.ACTIVITY_NOTIFY_LISTENER_END);
    }

    @Override
    public void remove() {
        PvmExecutionImpl parent = this.getParent();
        if (parent != null) {
            parent.getExecutions().remove(this);
        }
        this.isActive = false;
        this.isEnded = true;
        this.removeEventScopes();
    }

    @Override
    public void deleteCascade(String deleteReason) {
        this.deleteCascade(deleteReason, false);
    }

    public void deleteCascade(String deleteReason, boolean skipCustomListeners) {
        this.deleteReason = deleteReason;
        this.deleteRoot = true;
        this.isEnded = true;
        this.skipCustomListeners = skipCustomListeners;
        this.performOperation(PvmAtomicOperation.DELETE_CASCADE);
    }

    public void deleteCascade2(String deleteReason) {
        this.deleteReason = deleteReason;
        this.deleteRoot = true;
        this.performOperation(new FoxAtomicOperationDeleteCascadeFireActivityEnd());
    }

    public abstract PvmExecutionImpl getReplacedBy();

    public void setReplacedBy(PvmExecutionImpl replacedBy) {
        replacedBy.setActivityInstanceId(this.activityInstanceId);
    }

    public void replace(PvmExecutionImpl execution) {
        this.activityInstanceId = execution.getActivityInstanceId();
        execution.leaveActivityInstance();
    }

    @Override
    public void signal(String signalName, Object signalData) {
        if (this.getActivity() == null) {
            throw new PvmException("cannot signal execution " + this.id + ": it has no current activity");
        }
        SignallableActivityBehavior activityBehavior = (SignallableActivityBehavior)this.activity.getActivityBehavior();
        try {
            activityBehavior.signal(this, signalName, signalData);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PvmException("couldn't process signal '" + signalName + "' on activity '" + this.activity.getId() + "': " + e.getMessage(), e);
        }
    }

    @Override
    public void take(PvmTransition transition) {
        if (this.transition != null) {
            throw new PvmException("already taking a transition");
        }
        if (transition == null) {
            throw new PvmException("transition is null");
        }
        TransitionImpl transitionImpl = (TransitionImpl)transition;
        this.setActivity(transitionImpl.getSource());
        this.setTransition(transitionImpl);
        this.performOperation(PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_END);
    }

    @Override
    public void executeActivity(PvmActivity activity) {
        ActivityImpl activityImpl = (ActivityImpl)activity;
        if (activity.isConcurrent()) {
            this.nextActivity = activityImpl;
            this.performOperation(PvmAtomicOperation.ACTIVITY_START_CONCURRENT);
        } else if (activity.isCancelScope()) {
            this.nextActivity = activityImpl;
            this.performOperation(PvmAtomicOperation.ACTIVITY_START_CANCEL_SCOPE);
        } else {
            this.setActivity(activityImpl);
            this.performOperation(PvmAtomicOperation.ACTIVITY_START);
        }
    }

    @Override
    public List<ActivityExecution> findInactiveConcurrentExecutions(PvmActivity activity) {
        ArrayList<ActivityExecution> inactiveConcurrentExecutionsInActivity = new ArrayList<ActivityExecution>();
        ArrayList<PvmExecutionImpl> otherConcurrentExecutions = new ArrayList<PvmExecutionImpl>();
        if (this.isConcurrent()) {
            List<PvmExecutionImpl> concurrentExecutions = this.getParent().getAllChildExecutions();
            for (PvmExecutionImpl concurrentExecution : concurrentExecutions) {
                if (concurrentExecution.getActivity() == activity) {
                    if (concurrentExecution.isActive()) continue;
                    inactiveConcurrentExecutionsInActivity.add(concurrentExecution);
                    continue;
                }
                otherConcurrentExecutions.add(concurrentExecution);
            }
        } else if (!this.isActive()) {
            inactiveConcurrentExecutionsInActivity.add(this);
        } else {
            otherConcurrentExecutions.add(this);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("inactive concurrent executions in '" + activity + "': " + inactiveConcurrentExecutionsInActivity);
            log.fine("other concurrent executions: " + otherConcurrentExecutions);
        }
        return inactiveConcurrentExecutionsInActivity;
    }

    protected List<PvmExecutionImpl> getAllChildExecutions() {
        ArrayList<PvmExecutionImpl> childExecutions = new ArrayList<PvmExecutionImpl>();
        for (PvmExecutionImpl pvmExecutionImpl : this.getExecutions()) {
            childExecutions.add(pvmExecutionImpl);
            childExecutions.addAll(pvmExecutionImpl.getAllChildExecutions());
        }
        return childExecutions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void takeAll(List<PvmTransition> _transitions, List<? extends ActivityExecution> _recyclableExecutions) {
        ArrayList<? extends ActivityExecution> recyclableExecutions;
        ArrayList<PvmTransition> transitions = new ArrayList<PvmTransition>(_transitions);
        ArrayList<? extends ActivityExecution> arrayList = recyclableExecutions = _recyclableExecutions != null ? new ArrayList<ActivityExecution>(_recyclableExecutions) : new ArrayList();
        if (recyclableExecutions.size() > 1) {
            for (PvmExecutionImpl pvmExecutionImpl : recyclableExecutions) {
                if (!pvmExecutionImpl.isScope()) continue;
                throw new PvmException("joining scope executions is not allowed");
            }
        }
        PvmExecutionImpl concurrentRoot = this.isConcurrent && !this.isScope ? this.getParent() : this;
        ArrayList<PvmExecutionImpl> arrayList2 = new ArrayList<PvmExecutionImpl>();
        ArrayList<PvmExecutionImpl> concurrentInActiveExecutions = new ArrayList<PvmExecutionImpl>();
        for (PvmExecutionImpl pvmExecutionImpl : concurrentRoot.getExecutions()) {
            if (pvmExecutionImpl.isActive()) {
                arrayList2.add(pvmExecutionImpl);
                continue;
            }
            concurrentInActiveExecutions.add(pvmExecutionImpl);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("transitions to take concurrent: " + transitions);
            log.fine("active concurrent executions: " + arrayList2);
        }
        if (transitions.size() == 1 && arrayList2.isEmpty() && this.allExecutionsInSameActivity(concurrentInActiveExecutions)) {
            ArrayList<? extends ActivityExecution> recyclableExecutionImpls = recyclableExecutions;
            recyclableExecutions.remove(concurrentRoot);
            for (PvmExecutionImpl pvmExecutionImpl : recyclableExecutionImpls) {
                if (pvmExecutionImpl.isEnded()) continue;
                log.fine("pruning execution " + pvmExecutionImpl);
                pvmExecutionImpl.end(false);
            }
            log.fine("activating the concurrent root " + concurrentRoot + " as the single path of execution going forward");
            concurrentRoot.setActive(true);
            concurrentRoot.setActivity(this.activity);
            concurrentRoot.setConcurrent(this.hasConcurrentSiblings(concurrentRoot));
            concurrentRoot.take(transitions.get(0));
        } else {
            ArrayList<OutgoingExecution> outgoingExecutions = new ArrayList<OutgoingExecution>();
            recyclableExecutions.remove(concurrentRoot);
            log.fine("recyclable executions for reuse: " + recyclableExecutions);
            while (!transitions.isEmpty()) {
                void var10_16;
                TransitionImpl transitionImpl = (TransitionImpl)transitions.remove(0);
                Object var10_17 = null;
                if (recyclableExecutions.isEmpty()) {
                    PvmExecutionImpl pvmExecutionImpl = concurrentRoot.createExecution();
                    log.fine("new " + pvmExecutionImpl + " with parent " + pvmExecutionImpl.getParent() + " created to take transition " + transitionImpl);
                } else {
                    PvmExecutionImpl pvmExecutionImpl = (PvmExecutionImpl)recyclableExecutions.remove(0);
                    log.fine("recycled " + pvmExecutionImpl + " to take transition " + transitionImpl);
                }
                var10_16.setActive(true);
                var10_16.setScope(false);
                var10_16.setConcurrent(true);
                var10_16.setTransitionBeingTaken(transitionImpl);
                outgoingExecutions.add(new OutgoingExecution((PvmExecutionImpl)var10_16, transitionImpl, true));
            }
            concurrentRoot.setActivityInstanceId(concurrentRoot.getParentActivityInstanceId());
            boolean bl = outgoingExecutions.isEmpty();
            for (PvmExecutionImpl pvmExecutionImpl : recyclableExecutions) {
                log.fine("pruning execution " + pvmExecutionImpl);
                pvmExecutionImpl.end(bl);
            }
            for (OutgoingExecution outgoingExecution : outgoingExecutions) {
                outgoingExecution.take();
            }
            if (bl) {
                concurrentRoot.end(true);
            }
        }
    }

    protected boolean hasConcurrentSiblings(PvmExecutionImpl concurrentRoot) {
        if (concurrentRoot.isProcessInstanceExecution()) {
            return false;
        }
        List<? extends PvmExecutionImpl> executions = concurrentRoot.getParent().getExecutions();
        for (PvmExecutionImpl pvmExecutionImpl : executions) {
            if (pvmExecutionImpl == concurrentRoot || pvmExecutionImpl.isEventScope()) continue;
            return true;
        }
        return false;
    }

    protected boolean allExecutionsInSameActivity(List<PvmExecutionImpl> executions) {
        if (executions.size() > 1) {
            String activityId = executions.get(0).getActivityId();
            for (PvmExecutionImpl execution : executions) {
                String otherActivityId = execution.getActivityId();
                if (execution.isEnded || !(activityId == null && otherActivityId != null || activityId != null && otherActivityId == null) && (activityId == null || otherActivityId == null || otherActivityId.equals(activityId))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isActive(String activityId) {
        return this.findExecution(activityId) != null;
    }

    @Override
    public void inactivate() {
        this.isActive = false;
    }

    public abstract List<? extends PvmExecutionImpl> getExecutions();

    @Override
    public PvmExecutionImpl findExecution(String activityId) {
        if (this.getActivity() != null && this.getActivity().getId().equals(activityId)) {
            return this;
        }
        for (PvmExecutionImpl pvmExecutionImpl : this.getExecutions()) {
            PvmExecutionImpl result = pvmExecutionImpl.findExecution(activityId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public List<String> findActiveActivityIds() {
        ArrayList<String> activeActivityIds = new ArrayList<String>();
        this.collectActiveActivityIds(activeActivityIds);
        return activeActivityIds;
    }

    protected void collectActiveActivityIds(List<String> activeActivityIds) {
        ActivityImpl activity = this.getActivity();
        if (this.isActive && activity != null) {
            activeActivityIds.add(activity.getId());
        }
        for (PvmExecutionImpl pvmExecutionImpl : this.getExecutions()) {
            pvmExecutionImpl.collectActiveActivityIds(activeActivityIds);
        }
    }

    @Override
    public String getProcessBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    public void setProcessDefinition(ProcessDefinitionImpl processDefinition) {
        this.processDefinition = processDefinition;
    }

    public ProcessDefinitionImpl getProcessDefinition() {
        return this.processDefinition;
    }

    public abstract PvmExecutionImpl getProcessInstance();

    public abstract void setProcessInstance(PvmExecutionImpl var1);

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @Override
    public ActivityImpl getActivity() {
        return this.activity;
    }

    public String getActivityId() {
        ActivityImpl activity = this.getActivity();
        if (activity != null) {
            return activity.getId();
        }
        return null;
    }

    @Override
    public String getCurrentActivityName() {
        ActivityImpl activity = this.getActivity();
        if (activity != null) {
            return activity.getName();
        }
        return null;
    }

    @Override
    public String getCurrentActivityId() {
        return this.getActivityId();
    }

    @Override
    public void setActivity(PvmActivity activity) {
        this.activity = (ActivityImpl)activity;
    }

    @Override
    public void enterActivityInstance() {
        ActivityImpl activity = this.getActivity();
        if (activity == null && this.processInstanceStartContext != null) {
            activity = this.processInstanceStartContext.getInitial();
        }
        this.activityInstanceId = this.generateActivityInstanceId(activity.getId());
        if (log.isLoggable(Level.FINE)) {
            log.fine("[ENTER] " + this + ": " + this.activityInstanceId + ", parent: " + this.getParentActivityInstanceId());
        }
    }

    protected abstract String generateActivityInstanceId(String var1);

    @Override
    public void leaveActivityInstance() {
        if (this.activityInstanceId != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("[LEAVE] " + this + ": " + this.activityInstanceId);
            }
            this.activityInstanceId = this.getParentActivityInstanceId();
        }
        this.activityInstanceState = ActivityInstanceState.DEFAULT.getStateCode();
    }

    @Override
    public String getParentActivityInstanceId() {
        if (this.isProcessInstanceExecution()) {
            return this.getId();
        }
        PvmExecutionImpl parent = this.getParent();
        ActivityImpl activity = this.getActivity();
        ActivityImpl parentActivity = parent.getActivity();
        if (parent.isScope() && !this.isConcurrent() || parent.isConcurrent && activity != parentActivity) {
            return parent.getActivityInstanceId();
        }
        return parent.getParentActivityInstanceId();
    }

    public void forceUpdateActivityInstance() {
        this.activityInstanceId = this.generateActivityInstanceId(this.getActivity().getId());
    }

    @Override
    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    @Override
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    @Override
    public abstract PvmExecutionImpl getParent();

    @Override
    public String getParentId() {
        PvmExecutionImpl parent = this.getParent();
        if (parent != null) {
            return parent.getId();
        }
        return null;
    }

    public abstract void setParent(PvmExecutionImpl var1);

    public abstract PvmExecutionImpl getSuperExecution();

    public abstract void setSuperExecution(PvmExecutionImpl var1);

    public abstract PvmExecutionImpl getSubProcessInstance();

    public abstract void setSubProcessInstance(PvmExecutionImpl var1);

    public abstract CmmnExecution getSuperCaseExecution();

    public abstract void setSuperCaseExecution(CmmnExecution var1);

    protected ScopeImpl getScopeActivity() {
        ScopeImpl scope = null;
        scope = this.isProcessInstanceExecution() ? this.getProcessDefinition() : this.getActivity();
        return scope;
    }

    @Override
    public boolean isScope() {
        return this.isScope;
    }

    @Override
    public void setScope(boolean isScope) {
        this.isScope = isScope;
    }

    public String toString() {
        if (this.isProcessInstanceExecution()) {
            return "ProcessInstance[" + this.getToStringIdentity() + "]";
        }
        return (this.isConcurrent ? "Concurrent" : "") + (this.isScope ? "Scope" : "") + "Execution[" + this.getToStringIdentity() + "]";
    }

    protected String getToStringIdentity() {
        return this.id;
    }

    @Override
    public CoreVariableScope getParentVariableScope() {
        return this.getParent();
    }

    public String getDeleteReason() {
        return this.deleteReason;
    }

    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    public boolean isDeleteRoot() {
        return this.deleteRoot;
    }

    public TransitionImpl getTransition() {
        return this.transition;
    }

    @Override
    public String getCurrentTransitionId() {
        TransitionImpl transition = this.getTransition();
        if (transition != null) {
            return transition.getId();
        }
        return null;
    }

    public TransitionImpl getTransitionBeingTaken() {
        return this.transitionBeingTaken;
    }

    public void setTransition(TransitionImpl transition) {
        this.transition = transition;
    }

    public void setTransitionBeingTaken(TransitionImpl transitionBeingTaken) {
        this.transitionBeingTaken = transitionBeingTaken;
    }

    @Override
    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    @Override
    public void setConcurrent(boolean isConcurrent) {
        this.isConcurrent = isConcurrent;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public boolean isEnded() {
        return this.isEnded;
    }

    @Override
    public boolean isCanceled() {
        return ActivityInstanceState.CANCELED.getStateCode() == this.activityInstanceState;
    }

    public void setCanceled(boolean canceled) {
        if (canceled) {
            this.activityInstanceState = ActivityInstanceState.CANCELED.getStateCode();
        }
    }

    @Override
    public boolean isCompleteScope() {
        return ActivityInstanceState.SCOPE_COMPLETE.getStateCode() == this.activityInstanceState;
    }

    public void setCompleteScope(boolean completeScope) {
        if (completeScope) {
            this.activityInstanceState = ActivityInstanceState.SCOPE_COMPLETE.getStateCode();
        }
    }

    public int getActivityInstanceState() {
        return this.activityInstanceState;
    }

    public boolean isEventScope() {
        return this.isEventScope;
    }

    public void setEventScope(boolean isEventScope) {
        this.isEventScope = isEventScope;
    }

    public ExecutionStartContext getExecutionStartContext() {
        return this.startContext;
    }

    public void disposeProcessInstanceStartContext() {
        this.processInstanceStartContext = null;
    }

    public void disposeExecutionStartContext() {
        this.startContext = null;
    }

    @Override
    public ActivityImpl getNextActivity() {
        return this.nextActivity;
    }

    @Override
    public boolean isProcessInstanceExecution() {
        return this.getParent() == null;
    }

    public ProcessInstanceStartContext getProcessInstanceStartContext() {
        return this.processInstanceStartContext;
    }

    public void setStartContext(ExecutionStartContext startContext) {
        this.startContext = startContext;
    }
}

