/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.AuthorizationQueryImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.AuthorizationCheck;
import org.camunda.bpm.engine.impl.db.PersistentObject;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;

public class AuthorizationManager
extends AbstractManager {
    public Authorization createNewAuthorization(int type) {
        this.checkAuthorization(Permissions.CREATE, Resources.AUTHORIZATION, null);
        return new AuthorizationEntity(type);
    }

    @Override
    public void insert(PersistentObject authorization) {
        this.checkAuthorization(Permissions.CREATE, Resources.AUTHORIZATION, null);
        this.getDbSqlSession().insert(authorization);
    }

    public List<Authorization> selectAuthorizationByQueryCriteria(AuthorizationQueryImpl authorizationQuery) {
        this.configureQuery(authorizationQuery, Resources.AUTHORIZATION);
        return this.getDbSqlSession().selectList("selectAuthorizationByQueryCriteria", authorizationQuery);
    }

    public Long selectAuthorizationCountByQueryCriteria(AuthorizationQueryImpl authorizationQuery) {
        this.configureQuery(authorizationQuery, Resources.AUTHORIZATION);
        return (Long)this.getDbSqlSession().selectOne("selectAuthorizationCountByQueryCriteria", authorizationQuery);
    }

    public void update(AuthorizationEntity authorization) {
        this.checkAuthorization(Permissions.UPDATE, Resources.AUTHORIZATION, authorization.getId());
        this.getDbSqlSession().update(authorization);
    }

    @Override
    public void delete(PersistentObject authorization) {
        this.checkAuthorization(Permissions.DELETE, Resources.AUTHORIZATION, authorization.getId());
        this.deleteAuthorizationsByResourceId(Resources.AUTHORIZATION, authorization.getId());
        super.delete(authorization);
    }

    public void configureQuery(AbstractQuery query, Resource resource) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        Authentication currentAuthentication = Context.getCommandContext().getAuthentication();
        if (processEngineConfiguration.isAuthorizationEnabled() && currentAuthentication != null) {
            query.setAuthorizationCheckEnabled(true);
            query.setAuthUserId(currentAuthentication.getUserId());
            query.setAuthGroupIds(currentAuthentication.getGroupIds());
            query.setAuthResourceType(resource.resourceType());
            query.setAuthResourceIdQueryParam("RES.ID_");
            query.setAuthPerms(Permissions.READ.getValue());
        }
    }

    public void checkAuthorization(Permission permission, Resource resource, String resourceId) {
        boolean isAuthorized;
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        Authentication currentAuthentication = Context.getCommandContext().getAuthentication();
        if (processEngineConfiguration.isAuthorizationEnabled() && currentAuthentication != null && !(isAuthorized = this.isAuthorized(currentAuthentication.getUserId(), currentAuthentication.getGroupIds(), permission, resource, resourceId))) {
            throw new AuthorizationException(currentAuthentication.getUserId(), permission.getName(), resource.resourceName(), resourceId);
        }
    }

    public boolean isAuthorized(String userId, List<String> groupIds, Permission permission, Resource resource, String resourceId) {
        AuthorizationCheck authCheck = new AuthorizationCheck();
        authCheck.setAuthUserId(userId);
        authCheck.setAuthGroupIds(groupIds);
        authCheck.setAuthResourceType(resource.resourceType());
        authCheck.setAuthResourceId(resourceId);
        authCheck.setAuthPerms(permission.getValue());
        return this.getDbSqlSession().selectBoolean("isUserAuthorizedForResource", authCheck);
    }

    public boolean isAuthorized(Permission permission, Resource resource, String resourceId) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        Authentication currentAuthentication = Context.getCommandContext().getAuthentication();
        if (processEngineConfiguration.isAuthorizationEnabled() && currentAuthentication != null) {
            return this.isAuthorized(currentAuthentication.getUserId(), currentAuthentication.getGroupIds(), permission, resource, resourceId);
        }
        return true;
    }

    public void deleteAuthorizationsByResourceId(Resource resource, String resourceId) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Resource id cannot be null");
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration.isAuthorizationEnabled()) {
            HashMap<String, Object> deleteParams = new HashMap<String, Object>();
            deleteParams.put("resourceType", resource.resourceType());
            deleteParams.put("resourceId", resourceId);
            this.getDbSqlSession().delete("deleteAuthorizationsForResourceId", deleteParams);
        }
    }
}

