/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.form.type;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.form.type.AbstractFormFieldType;

public class BooleanFormType
extends AbstractFormFieldType {
    @Override
    public String getName() {
        return "boolean";
    }

    public String getMimeType() {
        return "plain/text";
    }

    @Override
    public Object convertFormValueToModelValue(Object propertyValue) {
        if (propertyValue == null || "".equals(propertyValue)) {
            return null;
        }
        return Boolean.valueOf(propertyValue.toString());
    }

    @Override
    public String convertModelValueToFormValue(Object modelValue) {
        if (modelValue == null) {
            return null;
        }
        if (Boolean.class.isAssignableFrom(modelValue.getClass()) || Boolean.TYPE.isAssignableFrom(modelValue.getClass())) {
            return modelValue.toString();
        }
        throw new ProcessEngineException("Model value is not of type boolean, but of type " + modelValue.getClass().getName());
    }
}

