/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.operation;

import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.operation.AbstractCmmnEventAtomicOperation;
import org.camunda.bpm.engine.impl.pvm.PvmException;

public class AtomicOperationCaseExecutionReactivate
extends AbstractCmmnEventAtomicOperation {
    @Override
    public String getCanonicalName() {
        return "case-execution-re-activate";
    }

    @Override
    protected String getEventName() {
        return "reactivate";
    }

    @Override
    protected CmmnExecution eventNotificationsStarted(CmmnExecution execution) {
        try {
            CmmnActivityBehavior behavior = this.getActivityBehavior(execution);
            behavior.onReactivation(execution);
            execution.setCurrentState(CaseExecutionState.ACTIVE);
        }
        catch (RuntimeException e) {
            String id = execution.getId();
            throw new PvmException("Cannot re-activate case execution '" + id + "'.", e);
        }
        return execution;
    }

    @Override
    protected void eventNotificationsCompleted(CmmnExecution execution) {
        CmmnActivityBehavior behavior = this.getActivityBehavior(execution);
        behavior.reactivated(execution);
    }
}

