/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.behavior;

import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmmn.behavior.ProcessOrCaseTaskActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;

public class ProcessTaskActivityBehavior
extends ProcessOrCaseTaskActivityBehavior {
    @Override
    protected void triggerCallableElement(CmmnActivityExecution execution, Map<String, Object> variables, String businessKey) {
        String processDefinitionKey = this.getDefinitionKey(execution);
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        ProcessDefinitionEntity processDefinition = null;
        if (this.isLatestBinding()) {
            processDefinition = deploymentCache.findDeployedLatestProcessDefinitionByKey(processDefinitionKey);
        } else if (this.isDeploymentBinding()) {
            String deploymentId = this.getDeploymentId(execution);
            processDefinition = deploymentCache.findDeployedProcessDefinitionByDeploymentAndKey(deploymentId, processDefinitionKey);
        } else if (this.isVersionBinding()) {
            Integer version = this.getVersion(execution);
            processDefinition = deploymentCache.findDeployedProcessDefinitionByKeyAndVersion(processDefinitionKey, version);
        }
        PvmProcessInstance caseInstance = execution.createSubProcessInstance(processDefinition);
        caseInstance.start(businessKey, variables);
    }

    @Override
    public void onManualCompletion(CmmnActivityExecution execution) {
        throw new ProcessEngineException("It is not possible to complete a process task manually.");
    }
}

