/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.identity.Picture;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityInfoEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class GetUserPictureCmd
implements Command<Picture>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String userId;

    public GetUserPictureCmd(String userId) {
        this.userId = userId;
    }

    @Override
    public Picture execute(CommandContext commandContext) {
        String pictureByteArrayId;
        EnsureUtil.ensureNotNull("userId", (Object)this.userId);
        IdentityInfoEntity pictureInfo = commandContext.getIdentityInfoManager().findUserInfoByUserIdAndKey(this.userId, "picture");
        if (pictureInfo != null && (pictureByteArrayId = pictureInfo.getValue()) != null) {
            ByteArrayEntity byteArray = commandContext.getDbSqlSession().selectById(ByteArrayEntity.class, pictureByteArrayId);
            return new Picture(byteArray.getBytes(), byteArray.getName());
        }
        return null;
    }
}

