/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class GetDeploymentResourceCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String resourceName;

    public GetDeploymentResourceCmd(String deploymentId, String resourceName) {
        this.deploymentId = deploymentId;
        this.resourceName = resourceName;
    }

    @Override
    public InputStream execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("deploymentId", (Object)this.deploymentId);
        EnsureUtil.ensureNotNull("resourceName", (Object)this.resourceName);
        ResourceEntity resource = commandContext.getResourceManager().findResourceByDeploymentIdAndResourceName(this.deploymentId, this.resourceName);
        EnsureUtil.ensureNotNull("no resource found with name '" + this.resourceName + "' in deployment '" + this.deploymentId + "'", "resource", (Object)resource);
        return new ByteArrayInputStream(resource.getBytes());
    }
}

