/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cmd.AbstractSetJobStateCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.persistence.entity.TaskManager;

public abstract class AbstractSetProcessInstanceStateCmd
implements Command<Void> {
    protected final String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionKey;

    public AbstractSetProcessInstanceStateCmd(String processInstanceId, String processDefinitionId, String processDefinitionKey) {
        this.processInstanceId = processInstanceId;
        this.processDefinitionId = processDefinitionId;
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.processInstanceId == null && this.processDefinitionId == null && this.processDefinitionKey == null) {
            throw new ProcessEngineException("ProcessInstanceId, ProcessDefinitionId nor ProcessDefinitionKey cannot be null.");
        }
        ExecutionManager executionManager = commandContext.getExecutionManager();
        TaskManager taskManager = commandContext.getTaskManager();
        SuspensionState suspensionState = this.getNewSuspensionState();
        if (this.processInstanceId != null) {
            executionManager.updateExecutionSuspensionStateByProcessInstanceId(this.processInstanceId, suspensionState);
            taskManager.updateTaskSuspensionStateByProcessInstanceId(this.processInstanceId, suspensionState);
        } else if (this.processDefinitionId != null) {
            executionManager.updateExecutionSuspensionStateByProcessDefinitionId(this.processDefinitionId, suspensionState);
            taskManager.updateTaskSuspensionStateByProcessDefinitionId(this.processDefinitionId, suspensionState);
        } else if (this.processDefinitionKey != null) {
            executionManager.updateExecutionSuspensionStateByProcessDefinitionKey(this.processDefinitionKey, suspensionState);
            taskManager.updateTaskSuspensionStateByProcessDefinitionKey(this.processDefinitionKey, suspensionState);
        }
        this.getSetJobStateCmd().execute(commandContext);
        return null;
    }

    protected abstract SuspensionState getNewSuspensionState();

    protected abstract AbstractSetJobStateCmd getSetJobStateCmd();
}

