/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;

public abstract class AbstractSetJobStateCmd
implements Command<Void> {
    protected String jobId;
    protected String jobDefinitionId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionKey;

    public AbstractSetJobStateCmd(String jobId, String jobDefinitionId, String processInstanceId, String processDefinitionId, String processDefinitionKey) {
        this.jobId = jobId;
        this.jobDefinitionId = jobDefinitionId;
        this.processInstanceId = processInstanceId;
        this.processDefinitionId = processDefinitionId;
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.jobId == null && this.jobDefinitionId == null && this.processInstanceId == null && this.processDefinitionId == null && this.processDefinitionKey == null) {
            throw new ProcessEngineException("Job id, job definition id, process instance id, process definition id nor process definition key cannot be null");
        }
        JobManager jobManager = commandContext.getJobManager();
        SuspensionState suspensionState = this.getSuspensionState();
        if (this.jobId != null) {
            jobManager.updateJobSuspensionStateById(this.jobId, suspensionState);
        } else if (this.jobDefinitionId != null) {
            jobManager.updateJobSuspensionStateByJobDefinitionId(this.jobDefinitionId, suspensionState);
        } else if (this.processInstanceId != null) {
            jobManager.updateJobSuspensionStateByProcessInstanceId(this.processInstanceId, suspensionState);
        } else if (this.processDefinitionId != null) {
            jobManager.updateJobSuspensionStateByProcessDefinitionId(this.processDefinitionId, suspensionState);
        } else if (this.processDefinitionKey != null) {
            jobManager.updateJobSuspensionStateByProcessDefinitionKey(this.processDefinitionKey, suspensionState);
        }
        return null;
    }

    protected abstract SuspensionState getSuspensionState();
}

