/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.QueryOperator;
import org.camunda.bpm.engine.impl.TaskQueryProperty;
import org.camunda.bpm.engine.impl.TaskQueryVariableValue;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.impl.variable.VariableTypes;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;

public class TaskQueryImpl
extends AbstractQuery<TaskQuery, Task>
implements TaskQuery {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String name;
    protected String nameLike;
    protected String description;
    protected String descriptionLike;
    protected Integer priority;
    protected Integer minPriority;
    protected Integer maxPriority;
    protected String assignee;
    protected String assigneeLike;
    protected String involvedUser;
    protected String owner;
    protected boolean unassigned = false;
    protected boolean noDelegationState = false;
    protected DelegationState delegationState;
    protected String candidateUser;
    protected String candidateGroup;
    private List<String> candidateGroups;
    protected String processInstanceId;
    protected String executionId;
    protected String[] activityInstanceIdIn;
    protected Date createTime;
    protected Date createTimeBefore;
    protected Date createTimeAfter;
    protected String key;
    protected String keyLike;
    protected String processDefinitionKey;
    protected String processDefinitionId;
    protected String processDefinitionName;
    protected String processDefinitionNameLike;
    protected String processInstanceBusinessKey;
    protected String processInstanceBusinessKeyLike;
    protected List<TaskQueryVariableValue> variables = new ArrayList<TaskQueryVariableValue>();
    protected Date dueDate;
    protected Date dueBefore;
    protected Date dueAfter;
    protected Date followUpDate;
    protected Date followUpBefore;
    protected Date followUpAfter;
    protected boolean excludeSubtasks = false;
    protected SuspensionState suspensionState;
    protected boolean initialzeFormKeys = false;
    protected String caseDefinitionKey;
    protected String caseDefinitionId;
    protected String caseDefinitionName;
    protected String caseDefinitionNameLike;
    protected String caseInstanceId;
    protected String caseInstanceBusinessKey;
    protected String caseInstanceBusinessKeyLike;
    protected String caseExecutionId;

    public TaskQueryImpl() {
    }

    public TaskQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public TaskQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public TaskQueryImpl taskId(String taskId) {
        EnsureUtil.ensureNotNull("Task id", (Object)taskId);
        this.taskId = taskId;
        return this;
    }

    @Override
    public TaskQueryImpl taskName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public TaskQueryImpl taskNameLike(String nameLike) {
        EnsureUtil.ensureNotNull("Task namelike", (Object)nameLike);
        this.nameLike = nameLike;
        return this;
    }

    @Override
    public TaskQueryImpl taskDescription(String description) {
        EnsureUtil.ensureNotNull("Description", (Object)description);
        this.description = description;
        return this;
    }

    @Override
    public TaskQuery taskDescriptionLike(String descriptionLike) {
        EnsureUtil.ensureNotNull("Task descriptionLike", (Object)descriptionLike);
        this.descriptionLike = descriptionLike;
        return this;
    }

    @Override
    public TaskQuery taskPriority(Integer priority) {
        EnsureUtil.ensureNotNull("Priority", (Object)priority);
        this.priority = priority;
        return this;
    }

    @Override
    public TaskQuery taskMinPriority(Integer minPriority) {
        EnsureUtil.ensureNotNull("Min Priority", (Object)minPriority);
        this.minPriority = minPriority;
        return this;
    }

    @Override
    public TaskQuery taskMaxPriority(Integer maxPriority) {
        EnsureUtil.ensureNotNull("Max Priority", (Object)maxPriority);
        this.maxPriority = maxPriority;
        return this;
    }

    @Override
    public TaskQueryImpl taskAssignee(String assignee) {
        EnsureUtil.ensureNotNull("Assignee", (Object)assignee);
        this.assignee = assignee;
        return this;
    }

    @Override
    public TaskQuery taskAssigneeLike(String assignee) {
        EnsureUtil.ensureNotNull("Assignee", (Object)assignee);
        this.assigneeLike = assignee;
        return this;
    }

    @Override
    public TaskQueryImpl taskOwner(String owner) {
        EnsureUtil.ensureNotNull("Owner", (Object)owner);
        this.owner = owner;
        return this;
    }

    @Override
    @Deprecated
    public TaskQuery taskUnnassigned() {
        return this.taskUnassigned();
    }

    @Override
    public TaskQuery taskUnassigned() {
        this.unassigned = true;
        return this;
    }

    @Override
    public TaskQuery taskDelegationState(DelegationState delegationState) {
        if (delegationState == null) {
            this.noDelegationState = true;
        } else {
            this.delegationState = delegationState;
        }
        return this;
    }

    @Override
    public TaskQueryImpl taskCandidateUser(String candidateUser) {
        EnsureUtil.ensureNotNull("Candidate user", (Object)candidateUser);
        if (this.candidateGroup != null) {
            throw new ProcessEngineException("Invalid query usage: cannot set both candidateUser and candidateGroup");
        }
        if (this.candidateGroups != null) {
            throw new ProcessEngineException("Invalid query usage: cannot set both candidateUser and candidateGroupIn");
        }
        this.candidateUser = candidateUser;
        return this;
    }

    @Override
    public TaskQueryImpl taskInvolvedUser(String involvedUser) {
        EnsureUtil.ensureNotNull("Involved user", (Object)involvedUser);
        this.involvedUser = involvedUser;
        return this;
    }

    @Override
    public TaskQueryImpl taskCandidateGroup(String candidateGroup) {
        EnsureUtil.ensureNotNull("Candidate group", (Object)candidateGroup);
        if (this.candidateUser != null) {
            throw new ProcessEngineException("Invalid query usage: cannot set both candidateGroup and candidateUser");
        }
        if (this.candidateGroups != null) {
            throw new ProcessEngineException("Invalid query usage: cannot set both candidateGroup and candidateGroupIn");
        }
        this.candidateGroup = candidateGroup;
        return this;
    }

    @Override
    public TaskQuery taskCandidateGroupIn(List<String> candidateGroups) {
        EnsureUtil.ensureNotEmpty("Candidate group list", candidateGroups);
        if (this.candidateUser != null) {
            throw new ProcessEngineException("Invalid query usage: cannot set both candidateGroupIn and candidateUser");
        }
        if (this.candidateGroup != null) {
            throw new ProcessEngineException("Invalid query usage: cannot set both candidateGroupIn and candidateGroup");
        }
        this.candidateGroups = candidateGroups;
        return this;
    }

    @Override
    public TaskQueryImpl processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public TaskQueryImpl processInstanceBusinessKey(String processInstanceBusinessKey) {
        this.processInstanceBusinessKey = processInstanceBusinessKey;
        return this;
    }

    @Override
    public TaskQuery processInstanceBusinessKeyLike(String processInstanceBusinessKey) {
        this.processInstanceBusinessKeyLike = processInstanceBusinessKey;
        return this;
    }

    @Override
    public TaskQueryImpl executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Override
    public TaskQuery activityInstanceIdIn(String ... activityInstanceIds) {
        this.activityInstanceIdIn = activityInstanceIds;
        return this;
    }

    @Override
    public TaskQueryImpl taskCreatedOn(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    @Override
    public TaskQuery taskCreatedBefore(Date before) {
        this.createTimeBefore = before;
        return this;
    }

    @Override
    public TaskQuery taskCreatedAfter(Date after) {
        this.createTimeAfter = after;
        return this;
    }

    @Override
    public TaskQuery taskDefinitionKey(String key) {
        this.key = key;
        return this;
    }

    @Override
    public TaskQuery taskDefinitionKeyLike(String keyLike) {
        this.keyLike = keyLike;
        return this;
    }

    @Override
    public TaskQuery caseInstanceId(String caseInstanceId) {
        EnsureUtil.ensureNotNull("caseInstanceId", (Object)caseInstanceId);
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Override
    public TaskQuery caseInstanceBusinessKey(String caseInstanceBusinessKey) {
        EnsureUtil.ensureNotNull("caseInstanceBusinessKey", (Object)caseInstanceBusinessKey);
        this.caseInstanceBusinessKey = caseInstanceBusinessKey;
        return this;
    }

    @Override
    public TaskQuery caseInstanceBusinessKeyLike(String caseInstanceBusinessKeyLike) {
        EnsureUtil.ensureNotNull("caseInstanceBusinessKeyLike", (Object)caseInstanceBusinessKeyLike);
        this.caseInstanceBusinessKeyLike = caseInstanceBusinessKeyLike;
        return this;
    }

    @Override
    public TaskQuery caseExecutionId(String caseExecutionId) {
        EnsureUtil.ensureNotNull("caseExecutionId", (Object)caseExecutionId);
        this.caseExecutionId = caseExecutionId;
        return this;
    }

    @Override
    public TaskQuery caseDefinitionId(String caseDefinitionId) {
        EnsureUtil.ensureNotNull("caseDefinitionId", (Object)caseDefinitionId);
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    @Override
    public TaskQuery caseDefinitionKey(String caseDefinitionKey) {
        EnsureUtil.ensureNotNull("caseDefinitionKey", (Object)caseDefinitionKey);
        this.caseDefinitionKey = caseDefinitionKey;
        return this;
    }

    @Override
    public TaskQuery caseDefinitionName(String caseDefinitionName) {
        EnsureUtil.ensureNotNull("caseDefinitionName", (Object)caseDefinitionName);
        this.caseDefinitionName = caseDefinitionName;
        return this;
    }

    @Override
    public TaskQuery caseDefinitionNameLike(String caseDefinitionNameLike) {
        EnsureUtil.ensureNotNull("caseDefinitionNameLike", (Object)caseDefinitionNameLike);
        this.caseDefinitionNameLike = caseDefinitionNameLike;
        return this;
    }

    @Override
    public TaskQuery taskVariableValueEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.EQUALS, true, false);
        return this;
    }

    @Override
    public TaskQuery taskVariableValueNotEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.NOT_EQUALS, true, false);
        return this;
    }

    @Override
    public TaskQuery taskVariableValueLike(String variableName, String variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.LIKE, true, false);
        return this;
    }

    @Override
    public TaskQuery taskVariableValueGreaterThan(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.GREATER_THAN, true, false);
        return this;
    }

    @Override
    public TaskQuery taskVariableValueGreaterThanOrEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.GREATER_THAN_OR_EQUAL, true, false);
        return this;
    }

    @Override
    public TaskQuery taskVariableValueLessThan(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.LESS_THAN, true, false);
        return this;
    }

    @Override
    public TaskQuery taskVariableValueLessThanOrEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.LESS_THAN_OR_EQUAL, true, false);
        return this;
    }

    @Override
    public TaskQuery processVariableValueEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.EQUALS, false, true);
        return this;
    }

    @Override
    public TaskQuery processVariableValueNotEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.NOT_EQUALS, false, true);
        return this;
    }

    @Override
    public TaskQuery processVariableValueLike(String variableName, String variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.LIKE, false, true);
        return this;
    }

    @Override
    public TaskQuery processVariableValueGreaterThan(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.GREATER_THAN, false, true);
        return this;
    }

    @Override
    public TaskQuery processVariableValueGreaterThanOrEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.GREATER_THAN_OR_EQUAL, false, true);
        return this;
    }

    @Override
    public TaskQuery processVariableValueLessThan(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.LESS_THAN, false, true);
        return this;
    }

    @Override
    public TaskQuery processVariableValueLessThanOrEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.LESS_THAN_OR_EQUAL, false, true);
        return this;
    }

    @Override
    public TaskQuery caseInstanceVariableValueEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.EQUALS, false, false);
        return this;
    }

    @Override
    public TaskQuery caseInstanceVariableValueNotEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.NOT_EQUALS, false, false);
        return this;
    }

    @Override
    public TaskQuery caseInstanceVariableValueLike(String variableName, String variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.LIKE, false, false);
        return this;
    }

    @Override
    public TaskQuery caseInstanceVariableValueGreaterThan(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.GREATER_THAN, false, false);
        return this;
    }

    @Override
    public TaskQuery caseInstanceVariableValueGreaterThanOrEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.GREATER_THAN_OR_EQUAL, false, false);
        return this;
    }

    @Override
    public TaskQuery caseInstanceVariableValueLessThan(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.LESS_THAN, false, false);
        return this;
    }

    @Override
    public TaskQuery caseInstanceVariableValueLessThanOrEquals(String variableName, Object variableValue) {
        this.addVariable(variableName, variableValue, QueryOperator.LESS_THAN_OR_EQUAL, false, false);
        return this;
    }

    @Override
    public TaskQuery processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public TaskQuery processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public TaskQuery processDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
        return this;
    }

    @Override
    public TaskQuery processDefinitionNameLike(String processDefinitionName) {
        this.processDefinitionNameLike = processDefinitionName;
        return this;
    }

    @Override
    public TaskQuery dueDate(Date dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Override
    public TaskQuery dueBefore(Date dueBefore) {
        this.dueBefore = dueBefore;
        return this;
    }

    @Override
    public TaskQuery dueAfter(Date dueAfter) {
        this.dueAfter = dueAfter;
        return this;
    }

    @Override
    public TaskQuery followUpDate(Date followUpDate) {
        this.followUpDate = followUpDate;
        return this;
    }

    @Override
    public TaskQuery followUpBefore(Date followUpBefore) {
        this.followUpBefore = followUpBefore;
        return this;
    }

    @Override
    public TaskQuery followUpAfter(Date followUpAfter) {
        this.followUpAfter = followUpAfter;
        return this;
    }

    @Override
    public TaskQuery excludeSubtasks() {
        this.excludeSubtasks = true;
        return this;
    }

    @Override
    public TaskQuery active() {
        this.suspensionState = SuspensionState.ACTIVE;
        return this;
    }

    @Override
    public TaskQuery suspended() {
        this.suspensionState = SuspensionState.SUSPENDED;
        return this;
    }

    @Override
    public TaskQuery initializeFormKeys() {
        this.initialzeFormKeys = true;
        return this;
    }

    public List<String> getCandidateGroups() {
        if (this.candidateGroup != null) {
            return Collections.singletonList(this.candidateGroup);
        }
        if (this.candidateUser != null) {
            return this.getGroupsForCandidateUser(this.candidateUser);
        }
        if (this.candidateGroups != null) {
            return this.candidateGroups;
        }
        return null;
    }

    protected List<String> getGroupsForCandidateUser(String candidateUser) {
        List groups = Context.getCommandContext().getReadOnlyIdentityProvider().createGroupQuery().groupMember(candidateUser).list();
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    protected void ensureVariablesInitialized() {
        VariableTypes types = Context.getProcessEngineConfiguration().getVariableTypes();
        for (TaskQueryVariableValue var : this.variables) {
            var.initialize(types);
        }
    }

    protected void addVariable(String name, Object value, QueryOperator operator, boolean isTaskVariable, boolean isProcessInstanceVariable) {
        EnsureUtil.ensureNotNull("name", (Object)name);
        if (value == null || this.isBoolean(value)) {
            switch (operator) {
                case GREATER_THAN: {
                    throw new ProcessEngineException("Booleans and null cannot be used in 'greater than' condition");
                }
                case LESS_THAN: {
                    throw new ProcessEngineException("Booleans and null cannot be used in 'less than' condition");
                }
                case GREATER_THAN_OR_EQUAL: {
                    throw new ProcessEngineException("Booleans and null cannot be used in 'greater than or equal' condition");
                }
                case LESS_THAN_OR_EQUAL: {
                    throw new ProcessEngineException("Booleans and null cannot be used in 'less than or equal' condition");
                }
                case LIKE: {
                    throw new ProcessEngineException("Booleans and null cannot be used in 'like' condition");
                }
            }
        }
        this.variables.add(new TaskQueryVariableValue(name, value, operator, isTaskVariable, isProcessInstanceVariable));
    }

    private boolean isBoolean(Object value) {
        if (value == null) {
            return false;
        }
        return Boolean.class.isAssignableFrom(value.getClass()) || Boolean.TYPE.isAssignableFrom(value.getClass());
    }

    @Override
    public TaskQuery orderByTaskId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.TASK_ID);
    }

    @Override
    public TaskQuery orderByTaskName() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.NAME);
    }

    @Override
    public TaskQuery orderByTaskDescription() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.DESCRIPTION);
    }

    @Override
    public TaskQuery orderByTaskPriority() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.PRIORITY);
    }

    @Override
    public TaskQuery orderByProcessInstanceId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.PROCESS_INSTANCE_ID);
    }

    @Override
    public TaskQuery orderByCaseInstanceId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.CASE_INSTANCE_ID);
    }

    @Override
    public TaskQuery orderByExecutionId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.EXECUTION_ID);
    }

    @Override
    public TaskQuery orderByCaseExecutionId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.CASE_EXECUTION_ID);
    }

    @Override
    public TaskQuery orderByTaskAssignee() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.ASSIGNEE);
    }

    @Override
    public TaskQuery orderByTaskCreateTime() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.CREATE_TIME);
    }

    @Override
    public TaskQuery orderByDueDate() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.DUE_DATE);
    }

    @Override
    public TaskQuery orderByFollowUpDate() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.FOLLOW_UP_DATE);
    }

    @Override
    public List<Task> executeList(CommandContext commandContext, Page page) {
        this.ensureVariablesInitialized();
        this.checkQueryOk();
        List<Task> taskList = commandContext.getTaskManager().findTasksByQueryCriteria(this);
        if (this.initialzeFormKeys) {
            for (Task task : taskList) {
                ((TaskEntity)task).initializeFormKey();
            }
        }
        return taskList;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        this.checkQueryOk();
        return commandContext.getTaskManager().findTaskCountByQueryCriteria(this);
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public String getAssigneeLike() {
        return this.assigneeLike;
    }

    public boolean getUnassigned() {
        return this.unassigned;
    }

    public DelegationState getDelegationState() {
        return this.delegationState;
    }

    public boolean getNoDelegationState() {
        return this.noDelegationState;
    }

    public String getDelegationStateString() {
        return this.delegationState != null ? this.delegationState.toString() : null;
    }

    public String getCandidateUser() {
        return this.candidateUser;
    }

    public String getCandidateGroup() {
        return this.candidateGroup;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String[] getActivityInstanceIdIn() {
        return this.activityInstanceIdIn;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionLike() {
        return this.descriptionLike;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getCreateTimeBefore() {
        return this.createTimeBefore;
    }

    public Date getCreateTimeAfter() {
        return this.createTimeAfter;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyLike() {
        return this.keyLike;
    }

    public List<TaskQueryVariableValue> getVariables() {
        return this.variables;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public String getProcessDefinitionNameLike() {
        return this.processDefinitionNameLike;
    }

    public String getProcessInstanceBusinessKey() {
        return this.processInstanceBusinessKey;
    }

    public String getProcessInstanceBusinessKeyLike() {
        return this.processInstanceBusinessKeyLike;
    }

    public boolean getExcludeSubtasks() {
        return this.excludeSubtasks;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getCaseInstanceBusinessKey() {
        return this.caseInstanceBusinessKey;
    }

    public String getCaseInstanceBusinessKeyLike() {
        return this.caseInstanceBusinessKeyLike;
    }

    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public String getCaseDefinitionName() {
        return this.caseDefinitionName;
    }

    public String getCaseDefinitionNameLike() {
        return this.caseDefinitionNameLike;
    }
}

