/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.QueryOperator;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.variable.ByteArrayType;
import org.camunda.bpm.engine.impl.variable.JPAEntityVariableType;
import org.camunda.bpm.engine.impl.variable.VariableType;
import org.camunda.bpm.engine.impl.variable.VariableTypes;

public class QueryVariableValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Object value;
    private QueryOperator operator;
    private VariableInstanceEntity variableInstanceEntity;
    private boolean local;

    public QueryVariableValue(String name, Object value, QueryOperator operator, boolean local) {
        this.name = name;
        this.value = value;
        this.operator = operator;
        this.local = local;
    }

    public void initialize(VariableTypes types) {
        if (this.variableInstanceEntity == null) {
            VariableType type = types.findVariableType(this.value);
            if (type instanceof ByteArrayType) {
                throw new ProcessEngineException("Variables of type ByteArray cannot be used to query");
            }
            if (type instanceof JPAEntityVariableType && this.operator != QueryOperator.EQUALS) {
                throw new ProcessEngineException("JPA entity variables can only be used in 'variableValueEquals'");
            }
            this.variableInstanceEntity = VariableInstanceEntity.create(this.name, type, this.value);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getOperator() {
        if (this.operator != null) {
            return this.operator.toString();
        }
        return QueryOperator.EQUALS.toString();
    }

    public String getTextValue() {
        if (this.variableInstanceEntity != null) {
            return this.variableInstanceEntity.getTextValue();
        }
        return null;
    }

    public Long getLongValue() {
        if (this.variableInstanceEntity != null) {
            return this.variableInstanceEntity.getLongValue();
        }
        return null;
    }

    public Double getDoubleValue() {
        if (this.variableInstanceEntity != null) {
            return this.variableInstanceEntity.getDoubleValue();
        }
        return null;
    }

    public String getTextValue2() {
        if (this.variableInstanceEntity != null) {
            return this.variableInstanceEntity.getTextValue2();
        }
        return null;
    }

    public String getType() {
        if (this.variableInstanceEntity != null) {
            return this.variableInstanceEntity.getType().getTypeName();
        }
        return null;
    }

    public boolean isLocal() {
        return this.local;
    }
}

